/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.TableSaxHandler;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Table<R>
implements ITable<R> {
    protected List<R> rows;
    private String name;

    protected abstract void addRow(List<String> var1, IRuntimeRepository var2);

    protected abstract void initKeyMaps();

    public void initFromXml(InputStream is, IRuntimeRepository productRepository, String qualifiedTableName) throws Exception {
        this.rows = new ArrayList<R>(200);
        this.name = qualifiedTableName;
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        saxParser.parse(new InputSource(is), (DefaultHandler)new TableSaxHandler(this, productRepository));
        ((ArrayList)this.rows).trimToSize();
        this.init();
    }

    protected void init() {
        this.initKeyMaps();
        this.performAdditionalInitializations();
    }

    protected void performAdditionalInitializations() {
    }

    protected boolean isNull(Element valueElement) {
        return Boolean.parseBoolean(valueElement.getAttribute("isNull"));
    }

    public String toString() {
        return this.rows.stream().limit(10L).map(Object::toString).collect(Collectors.joining("\n"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<R> getAllRows() {
        return Collections.unmodifiableList(this.rows);
    }
}

