/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.resteasy;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import org.fakereplace.api.ChangedClass;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.api.NewClassData;
import org.fakereplace.data.InstanceTracker;
import org.fakereplace.integration.resteasy.ResteasyFilterConfig;
import org.fakereplace.integration.resteasy.ResteasyServletConfig;
import org.fakereplace.integration.resteasy.ResteasyServletContext;
import org.fakereplace.logging.Logger;

public class ResteasyClassChangeAware
implements ClassChangeAware {
    private static final String RESOURCES = "resteasy.scanned.resources";
    private final Logger logger = Logger.getLogger(ResteasyClassChangeAware.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterChange(List<ChangedClass> changed, List<NewClassData> added) {
        boolean requiresRestart = false;
        ClassLoader classLoader = null;
        for (ChangedClass c : changed) {
            if (c.getChangedAnnotationsByType(Path.class).isEmpty() && !c.getChangedClass().isAnnotationPresent(Path.class)) continue;
            requiresRestart = true;
            classLoader = c.getChangedClass().getClassLoader();
            break;
        }
        HashSet<String> addedResources = new HashSet<String>();
        for (NewClassData add : added) {
            AnnotationsAttribute attribute = (AnnotationsAttribute)add.getClassFile().getAttribute("RuntimeVisibleAnnotations");
            if (attribute == null) continue;
            if (attribute.getAnnotation(Path.class.getName()) != null) {
                addedResources.add(add.getClassName());
                requiresRestart = true;
            }
            if (classLoader != null) continue;
            classLoader = add.getClassLoader();
        }
        if (requiresRestart) {
            ClassLoader old;
            Set doNotClear;
            Object sc;
            StringBuilder res;
            Object config;
            for (Object servlet : InstanceTracker.get((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher")) {
                try {
                    config = (ResteasyServletConfig)servlet.getClass().getField("__CONFIG").get(servlet);
                    if (((ResteasyServletConfig)config).getClassLoader() != classLoader) continue;
                    res = new StringBuilder(((ResteasyServletConfig)config).getServletContext().getInitParameter(RESOURCES));
                    for (String add : addedResources) {
                        res.append(",").append(add);
                    }
                    sc = new ResteasyServletContext(((ResteasyServletConfig)config).getServletContext());
                    ((ResteasyServletContext)sc).getInitParams().put(RESOURCES, res.toString());
                    ((ResteasyServletConfig)config).setServletContext((ServletContext)sc);
                    doNotClear = (Set)servlet.getClass().getField("__PARAMS").get(servlet);
                    this.clearContext(((ResteasyServletConfig)config).getServletContext(), doNotClear);
                    old = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    try {
                        servlet.getClass().getMethod("destroy", new Class[0]).invoke(servlet, new Object[0]);
                        servlet.getClass().getMethod("init", ServletConfig.class).invoke(servlet, config);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                }
                catch (Exception e) {
                    this.logger.debug("Could not restart RESTeasy", (Throwable)e);
                }
            }
            for (Object filter : InstanceTracker.get((String)"org.jboss.resteasy.plugins.server.servlet.FilterDispatcher")) {
                try {
                    config = (ResteasyFilterConfig)filter.getClass().getField("__CONFIG").get(filter);
                    if (((ResteasyFilterConfig)config).getClassLoader() != classLoader) continue;
                    res = new StringBuilder((String)((ResteasyFilterConfig)config).getServletContext().getAttribute(RESOURCES));
                    for (String add : addedResources) {
                        res.append(",").append(add);
                    }
                    sc = new ResteasyServletContext(((ResteasyFilterConfig)config).getServletContext());
                    ((ResteasyServletContext)sc).getInitParams().put(RESOURCES, res.toString());
                    ((ResteasyFilterConfig)config).setServletContext((ServletContext)sc);
                    doNotClear = (Set)filter.getClass().getField("__PARAMS").get(filter);
                    this.clearContext(((ResteasyFilterConfig)config).getServletContext(), doNotClear);
                    old = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    try {
                        filter.getClass().getMethod("destroy", new Class[0]).invoke(filter, new Object[0]);
                        filter.getClass().getMethod("init", FilterConfig.class).invoke(filter, config);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                }
                catch (Exception e) {
                    this.logger.debug("Could not restart RESTeasy", (Throwable)e);
                }
            }
        }
    }

    private void clearContext(ServletContext servletContext, Set<String> doNotClear) {
        Enumeration names = servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            if (!name.startsWith("org.jboss.resteasy") || doNotClear.contains(name)) continue;
            servletContext.removeAttribute(name);
        }
    }
}

