/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.resteasy;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class ResteasyServletConfig
implements ServletConfig {
    private final String servletName;
    private ServletContext servletContext;
    private final Map<String, String> initParams;
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public ResteasyServletConfig(ServletConfig config) {
        this.servletName = config.getServletName();
        this.servletContext = config.getServletContext();
        this.initParams = new HashMap<String, String>();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this.initParams.put(name, config.getInitParameter(name));
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public String getServletName() {
        return this.servletName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getInitParameter(String s) {
        return this.initParams.get(s);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Enumeration getInitParameterNames() {
        final Iterator<String> it = this.initParams.keySet().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }
}

