/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.fun;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;
import org.expath.tools.saxon.fun.Library;
import org.expath.tools.saxon.fun.Param;
import org.expath.tools.saxon.model.SaxonElement;
import org.expath.tools.saxon.model.SaxonSequence;

public class Parameters {
    private net.sf.saxon.om.Sequence[] myParams;
    private Param[] myFormals;
    private final Library myLib;

    public Parameters(Library lib, net.sf.saxon.om.Sequence[] params, int min, Param[] formals) throws XPathException {
        int max = formals.length;
        if (params.length < min || params.length > max) {
            if (min == max) {
                throw new XPathException("There is not exactly " + min + " params: " + params.length);
            }
            throw new XPathException("There is not between " + min + " and " + max + " params: " + params.length);
        }
        this.myParams = params;
        this.myFormals = formals;
        this.myLib = lib;
    }

    public int number() {
        return this.myParams.length;
    }

    public String asString(int pos, boolean optional) throws XPathException {
        Item item = this.asItem(pos, optional);
        if (item == null) {
            return null;
        }
        if (!(item instanceof StringValue)) {
            throw new XPathException("The param $" + this.myFormals[pos].name() + " is not a string");
        }
        return item.getStringValue();
    }

    public Boolean asBoolean(int pos, boolean optional) throws XPathException {
        Item item = this.asItem(pos, optional);
        if (item == null) {
            return null;
        }
        if (!(item instanceof BooleanValue)) {
            throw new XPathException("The param $" + this.myFormals[pos].name() + " is not a boolean");
        }
        BooleanValue v = (BooleanValue)item;
        return v.getBooleanValue();
    }

    public Long asLong(int pos, boolean optional) throws XPathException {
        Item item = this.asItem(pos, optional);
        if (item == null) {
            return null;
        }
        if (!(item instanceof IntegerValue)) {
            throw new XPathException("The param $" + this.myFormals[pos].name() + " is not an integer");
        }
        IntegerValue v = (IntegerValue)item;
        return v.longValue();
    }

    public List<String> asStringList(int pos, boolean optional) throws XPathException {
        SequenceIterator it = this.initiate(pos, optional);
        if (null == it) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Item item = it.next();
        while (item != null) {
            if (!(item instanceof StringValue)) {
                throw new XPathException("Some value in the param $" + this.myFormals[pos].name() + " is not a string");
            }
            String value = item.getStringValue();
            result.add(value);
            item = it.next();
        }
        return result;
    }

    public byte[] asBinary(int pos, boolean optional) throws XPathException {
        Item item = this.asItem(pos, optional);
        if (item == null) {
            return null;
        }
        if (!(item instanceof Base64BinaryValue)) {
            throw new XPathException("The param $" + this.myFormals[pos].name() + " is not a base64 binary");
        }
        Base64BinaryValue bin = (Base64BinaryValue)item;
        return bin.getBinaryValue();
    }

    public Element asElement(int pos, boolean optional, XPathContext ctxt) throws XPathException {
        Item item = this.asItem(pos, optional);
        if (item == null) {
            return null;
        }
        if (!(item instanceof NodeInfo)) {
            throw new XPathException("The param $" + this.myFormals[pos].name() + " is not a node");
        }
        NodeInfo node = (NodeInfo)item;
        int kind = node.getNodeKind();
        if (kind != 1) {
            throw new XPathException("The param $" + this.myFormals[pos].name() + " is not an element (kind: " + kind + ")");
        }
        try {
            return new SaxonElement(node, ctxt);
        }
        catch (ToolsException ex) {
            throw new XPathException("Error creating an EXPath Saxon element", (Throwable)ex);
        }
    }

    public Element asElement(int pos, boolean optional, XPathContext ctxt, String name) throws XPathException {
        Element elem = this.asElement(pos, optional, ctxt);
        String actual_name = elem.getLocalName();
        if (!actual_name.equals(name)) {
            String msg = "The param $" + this.myFormals[pos].name() + " element local name is: " + actual_name + ", instead of: " + name;
            throw new XPathException(msg);
        }
        String actual_ns = elem.getNamespaceUri();
        if (!actual_ns.equals(this.myLib.getNamespace())) {
            String msg = "The param $" + this.myFormals[pos].name() + " element namespace is: " + actual_ns + ", instead of: " + this.myLib.getNamespace();
            throw new XPathException(msg);
        }
        return elem;
    }

    public Sequence asSequence(int pos, boolean optional, XPathContext ctxt) throws XPathException {
        SequenceIterator it = this.initiate(pos, optional);
        return new SaxonSequence(it, ctxt);
    }

    private Item asItem(int pos, boolean optional) throws XPathException {
        SequenceIterator it = this.initiate(pos, optional);
        if (null == it) {
            return null;
        }
        Item item = it.next();
        if (it.next() != null) {
            throw new XPathException("The param $" + this.myFormals[pos].name() + " sequence has more than one item");
        }
        return item;
    }

    private SequenceIterator initiate(int pos, boolean optional) throws XPathException {
        if (pos < 0 || pos >= this.number()) {
            throw new XPathException("Asked for the " + this.ordinal(pos) + " param of " + this.number());
        }
        net.sf.saxon.om.Sequence param = this.myParams[pos];
        SequenceIterator it = param.iterate();
        SequenceIterator res = it.getAnother();
        if (it.next() == null) {
            if (optional) {
                return null;
            }
            throw new XPathException("The param $" + this.myFormals[pos].name() + " is an empty sequence");
        }
        return res;
    }

    private String ordinal(int pos) throws XPathException {
        if (pos == 0) {
            return "1st";
        }
        if (pos == 1) {
            return "2d";
        }
        if (pos == 2) {
            return "3d";
        }
        if (pos > 2) {
            return pos + 1 + "th";
        }
        throw new XPathException("pos must be 0 or above, and is: " + pos);
    }

    public Formatter format(String name) {
        return new Formatter(name, this.myParams.length, this.myFormals.length);
    }

    public class Formatter {
        private final StringBuilder myBuf;
        private final int myNum;
        private final int myMax;
        private int myI;

        public Formatter(String name, int num, int max) {
            this.myNum = num;
            this.myMax = max;
            this.myI = 0;
            this.myBuf = new StringBuilder("Calling ");
            this.myBuf.append(Parameters.this.myLib.getPrefix());
            this.myBuf.append(":");
            this.myBuf.append(name);
            this.myBuf.append("(");
        }

        public Formatter param(String value) throws XPathException {
            if (this.checkPos()) {
                if (value == null) {
                    this.myBuf.append("()");
                } else {
                    this.myBuf.append("'");
                    this.myBuf.append(value.replace("'", "''"));
                    this.myBuf.append("'");
                }
            }
            return this;
        }

        public Formatter param(Item item) throws XPathException {
            if (this.checkPos()) {
                if (item == null) {
                    this.myBuf.append("()");
                } else {
                    this.myBuf.append(item.toString());
                }
            }
            return this;
        }

        public Formatter param(byte[] value) throws XPathException {
            if (this.checkPos()) {
                if (value == null) {
                    this.myBuf.append("()");
                } else {
                    this.myBuf.append("#<TODO: binary: ");
                    this.myBuf.append(value);
                    this.myBuf.append(">");
                }
            }
            return this;
        }

        public Formatter param(net.sf.saxon.om.Sequence value) throws XPathException {
            if (this.checkPos()) {
                if (value == null) {
                    this.myBuf.append("()");
                } else {
                    this.myBuf.append("#<TODO: sequence: ");
                    this.myBuf.append(value);
                    this.myBuf.append(">");
                }
            }
            return this;
        }

        public Formatter param(List<String> value) throws XPathException {
            if (this.checkPos()) {
                this.myBuf.append("(");
                if (value != null) {
                    boolean first = true;
                    for (String v : value) {
                        if (!first) {
                            this.myBuf.append(",");
                        }
                        this.myBuf.append("'");
                        this.myBuf.append(v.replace("'", "''"));
                        this.myBuf.append("'");
                        first = false;
                    }
                }
                this.myBuf.append(")");
            }
            return this;
        }

        public String value() {
            this.myBuf.append(")");
            return this.myBuf.toString();
        }

        private boolean checkPos() throws XPathException {
            boolean doit;
            ++this.myI;
            if (this.myI > this.myMax) {
                throw new XPathException("too much params: " + Parameters.this.ordinal(this.myI) + ", max: " + this.myMax);
            }
            boolean bl = doit = this.myI <= this.myNum;
            if (doit && this.myI > 1) {
                this.myBuf.append(", ");
            }
            return doit;
        }
    }
}

