/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Optional;
import org.everit.json.schema.FormatValidator;

public class DateTimeFormatValidator
implements FormatValidator {
    private static final String DATETIME_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final String DATETIME_FORMAT_STRING_SECFRAC = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    private SimpleDateFormat dateFormat(String pattern) {
        SimpleDateFormat rval = new SimpleDateFormat(pattern);
        rval.setLenient(false);
        return rval;
    }

    @Override
    public Optional<String> validate(String subject) {
        try {
            this.dateFormat(DATETIME_FORMAT_STRING).parse(subject);
            return Optional.empty();
        }
        catch (ParseException e) {
            try {
                this.dateFormat(DATETIME_FORMAT_STRING_SECFRAC).parse(subject);
                return Optional.empty();
            }
            catch (ParseException e1) {
                return Optional.of(String.format("[%s] is not a valid date-time", subject));
            }
        }
    }

    @Override
    public String formatName() {
        return "date-time";
    }
}

