/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.esigate.http.BasicCloseableHttpResponse;
import org.esigate.http.ContentTypeHelper;
import org.esigate.http.DateUtils;
import org.esigate.http.HttpResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCapturingWrapper
extends HttpServletResponseWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCapturingWrapper.class);
    private ServletOutputStream outputStream;
    private PrintWriter writer;
    private ServletOutputStream responseOutputStream;
    private PrintWriter responseWriter;
    private ByteArrayOutputStream internalOutputStream;
    private StringBuilderWriter internalWriter;
    private HttpServletResponse response;
    private CloseableHttpResponse httpClientResponse = BasicCloseableHttpResponse.adapt((HttpResponse)new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK")));
    private String contentType;
    private String characterEncoding;
    private int bufferSize;
    private int bytesWritten = 0;
    private boolean committed = false;
    private ContentTypeHelper contentTypeHelper;
    private final boolean proxy;
    private boolean capture = true;

    public ResponseCapturingWrapper(HttpServletResponse response, ContentTypeHelper contentTypeHelper, boolean proxy, int bufferSize) {
        super(response);
        this.response = response;
        this.bufferSize = bufferSize;
        this.contentTypeHelper = contentTypeHelper;
        this.proxy = proxy;
    }

    public void setStatus(int sc) {
        this.httpClientResponse.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, sc, ""));
    }

    public void setStatus(int sc, String sm) {
        this.httpClientResponse.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, sc, sm));
    }

    public int getStatus() {
        return this.httpClientResponse.getStatusLine().getStatusCode();
    }

    public void sendError(int sc, String msg) {
        this.httpClientResponse.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, sc, msg));
    }

    public void sendError(int sc) {
        this.httpClientResponse.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, sc, ""));
    }

    public void sendRedirect(String location) {
        this.httpClientResponse.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 307, "Temporary redirect"));
        this.httpClientResponse.setHeader("Location", location);
    }

    public boolean containsHeader(String name) {
        return this.httpClientResponse.containsHeader(name);
    }

    public void setHeader(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else {
            this.httpClientResponse.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else {
            this.httpClientResponse.addHeader(name, value);
        }
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, DateUtils.formatDate((long)date));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, DateUtils.formatDate((long)date));
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void setContentLength(int len) {
        this.setHeader("Content-Length", Integer.toString(len));
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
        this.updateContentTypeHeader();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        Header contentTypeHeader = this.httpClientResponse.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    public void setContentType(String type) {
        ContentType contentType = ContentType.parse((String)type);
        this.contentType = contentType.getMimeType();
        if (contentType.getCharset() != null) {
            this.characterEncoding = contentType.getCharset().name();
        }
        this.updateContentTypeHeader();
    }

    private void updateContentTypeHeader() {
        if (this.contentType != null) {
            if (this.characterEncoding == null) {
                this.httpClientResponse.setHeader("Content-Type", this.contentType);
            } else {
                this.httpClientResponse.setHeader("Content-Type", this.contentType + ";charset=" + this.characterEncoding);
            }
        }
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
        if (this.characterEncoding == null) {
            this.characterEncoding = this.response.getCharacterEncoding();
            this.updateContentTypeHeader();
        }
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public String encodeURL(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.response.encodeUrl(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.response.encodeRedirectUrl(url);
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        this.httpClientResponse = BasicCloseableHttpResponse.adapt((HttpResponse)new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK")));
    }

    public ServletOutputStream getOutputStream() {
        LOG.debug("getOutputStream");
        if (this.writer != null) {
            throw new IllegalStateException("Writer already obtained");
        }
        if (this.outputStream == null) {
            this.internalOutputStream = new ByteArrayOutputStream(1024);
            this.outputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    if (ResponseCapturingWrapper.this.capture || ResponseCapturingWrapper.this.bytesWritten < ResponseCapturingWrapper.this.bufferSize) {
                        ResponseCapturingWrapper.this.internalOutputStream.write(b);
                    } else {
                        ResponseCapturingWrapper.this.responseOutputStream.write(b);
                    }
                    ResponseCapturingWrapper.this.bytesWritten++;
                    if (ResponseCapturingWrapper.this.bytesWritten == ResponseCapturingWrapper.this.bufferSize) {
                        this.commit();
                    }
                }

                public void flush() throws IOException {
                    this.commit();
                }

                public void close() throws IOException {
                    this.commit();
                }

                private void commit() throws IOException {
                    if (!ResponseCapturingWrapper.this.committed) {
                        ResponseCapturingWrapper.this.capture = ResponseCapturingWrapper.this.hasToCaptureOutput();
                        if (!ResponseCapturingWrapper.this.capture) {
                            ResponseCapturingWrapper.this.responseOutputStream = ResponseCapturingWrapper.this.response.getOutputStream();
                            ResponseCapturingWrapper.this.internalOutputStream.writeTo((OutputStream)ResponseCapturingWrapper.this.responseOutputStream);
                        }
                        ResponseCapturingWrapper.this.committed = true;
                    }
                }
            };
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() {
        LOG.debug("getWriter");
        if (this.outputStream != null) {
            throw new IllegalStateException("OutputStream already obtained");
        }
        if (this.writer == null) {
            this.internalWriter = new StringBuilderWriter(1024);
            this.writer = new PrintWriter(new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    if (ResponseCapturingWrapper.this.capture || ResponseCapturingWrapper.this.bytesWritten < ResponseCapturingWrapper.this.bufferSize) {
                        ResponseCapturingWrapper.this.internalWriter.write(cbuf, off, len);
                    } else {
                        ResponseCapturingWrapper.this.responseWriter.write(cbuf, off, len);
                    }
                    ResponseCapturingWrapper.this.bytesWritten++;
                    if (ResponseCapturingWrapper.this.bytesWritten == ResponseCapturingWrapper.this.bufferSize) {
                        this.commit();
                    }
                }

                @Override
                public void flush() throws IOException {
                    this.commit();
                }

                @Override
                public void close() throws IOException {
                    this.commit();
                }

                private void commit() throws IOException {
                    if (!ResponseCapturingWrapper.this.committed) {
                        ResponseCapturingWrapper.this.capture = ResponseCapturingWrapper.this.hasToCaptureOutput();
                        if (!ResponseCapturingWrapper.this.capture) {
                            ResponseCapturingWrapper.this.responseWriter = ResponseCapturingWrapper.this.response.getWriter();
                            ResponseCapturingWrapper.this.responseWriter.write(ResponseCapturingWrapper.this.internalWriter.toString());
                        }
                        ResponseCapturingWrapper.this.committed = true;
                    }
                }
            });
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        if (this.internalOutputStream != null) {
            this.internalOutputStream.reset();
        }
        if (this.internalWriter != null) {
            this.internalWriter = new StringBuilderWriter(1024);
        }
        this.bytesWritten = 0;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    private boolean hasToCaptureOutput() {
        return !this.proxy || this.contentTypeHelper.isTextContentType((HttpResponse)this.httpClientResponse) || HttpResponseUtils.getFirstHeader((String)"Content-Type", (HttpResponse)this.httpClientResponse) == null;
    }

    public CloseableHttpResponse getCloseableHttpResponse() {
        ContentType contentType = null;
        if (this.contentType != null) {
            contentType = ContentType.create((String)this.contentType, (String)this.characterEncoding);
        }
        if (this.internalWriter != null) {
            this.httpClientResponse.setEntity((HttpEntity)new StringEntity(this.internalWriter.toString(), contentType));
        } else if (this.internalOutputStream != null) {
            this.httpClientResponse.setEntity((HttpEntity)new ByteArrayEntity(this.internalOutputStream.toByteArray(), contentType));
        }
        return this.httpClientResponse;
    }
}

