/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import org.esigate.impl.UriMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUrl {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUrl.class);

    private RequestUrl() {
    }

    public static String getRelativeUrl(HttpServletRequest request, boolean servlet) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String relativeUrl = requestURI;
        if (contextPath != null && relativeUrl.startsWith(contextPath)) {
            relativeUrl = relativeUrl.substring(contextPath.length());
        }
        if (servlet && servletPath != null && relativeUrl.startsWith(servletPath)) {
            relativeUrl = relativeUrl.substring(servletPath.length());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("requestURI: {}, contextPath: {}, servletPath: {}, relativeUrl: {}, ", new Object[]{requestURI, contextPath, servletPath, relativeUrl});
        }
        return relativeUrl;
    }

    public static String stripMappingPath(String url, UriMapping mapping) {
        String mappingPath;
        String relativeUrl = url;
        String string = mappingPath = mapping == null ? null : mapping.getPath();
        if (mappingPath != null && url.startsWith(mappingPath)) {
            relativeUrl = relativeUrl.substring(mappingPath.length());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("url: {}, mappingPath: {}, relativeUrl: {}", new Object[]{url, mappingPath, relativeUrl});
        }
        return relativeUrl;
    }
}

