/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.impl.UriMapping;
import org.esigate.servlet.impl.RequestUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverSelector {
    private static final Logger LOG = LoggerFactory.getLogger(DriverSelector.class);

    public ProviderContext selectProvider(HttpServletRequest request) throws HttpErrorPage {
        return this.selectProvider(request, false);
    }

    public ProviderContext selectProvider(HttpServletRequest request, boolean servlet) throws HttpErrorPage {
        String host = request.getHeader("Host");
        String scheme = request.getScheme();
        String relUrl = RequestUrl.getRelativeUrl(request, servlet);
        Pair result = DriverFactory.getInstanceFor((String)scheme, (String)host, (String)relUrl);
        ProviderContext context = new ProviderContext();
        Driver driver = (Driver)result.getLeft();
        UriMapping uriMapping = (UriMapping)result.getRight();
        if (driver.getConfiguration().isStripMappingPath()) {
            relUrl = RequestUrl.stripMappingPath(relUrl, uriMapping);
        }
        context.driver = driver;
        context.relUrl = relUrl;
        LOG.debug("Selected {} for scheme:{} host:{} relUrl:{}", new Object[]{result, scheme, host, relUrl});
        return context;
    }

    public class ProviderContext {
        private Driver driver;
        private String relUrl;

        public String getRelUrl() {
            return this.relUrl;
        }

        public Driver getDriver() {
            return this.driver;
        }
    }
}

