/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.http.IncomingRequest;
import org.esigate.servlet.impl.DriverSelector;
import org.esigate.servlet.impl.RequestFactory;
import org.esigate.servlet.impl.ResponseSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyFilter.class);
    private RequestFactory requestFactory;
    private final DriverSelector driverSelector = new DriverSelector();
    private final ResponseSender responseSender = new ResponseSender();

    public void init(FilterConfig filterConfig) {
        this.requestFactory = new RequestFactory(filterConfig.getServletContext());
        DriverFactory.ensureConfigured();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        block2: {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            IncomingRequest incomingRequest = this.requestFactory.create(httpServletRequest, httpServletResponse, chain);
            try {
                DriverSelector.ProviderContext dm = this.driverSelector.selectProvider(httpServletRequest, false);
                CloseableHttpResponse driverResponse = dm.getDriver().proxy(dm.getRelUrl(), incomingRequest, new Renderer[0]);
                this.responseSender.sendResponse((HttpResponse)driverResponse, incomingRequest, httpServletResponse);
            }
            catch (HttpErrorPage e) {
                if (httpServletResponse.isCommitted()) break block2;
                this.responseSender.sendResponse((HttpResponse)e.getHttpResponse(), incomingRequest, httpServletResponse);
            }
        }
    }

    public void destroy() {
    }
}

