/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.jsf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntityEnclosingRequest;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.jsf.IncludeParamComponent;
import org.esigate.jsf.ReplaceComponent;
import org.esigate.jsf.UIComponentUtils;
import org.esigate.regexp.ReplaceRenderer;
import org.esigate.servlet.HttpServletMediator;
import org.esigate.taglib.ReplaceableTag;
import org.esigate.tags.TemplateRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeTemplateComponent
extends UIComponentBase
implements ReplaceableTag {
    private Boolean displayErrorPage;
    private String name;
    private String page;
    private final Map<String, String> params = new HashMap<String, String>();
    private String provider;
    private final Map<String, String> replaceRules = new HashMap<String, String>();

    public void encodeChildren(FacesContext context) throws IOException {
        for (UIComponent child : this.getChildren()) {
            UIComponentUtils.renderChild(child);
            if (child instanceof ReplaceComponent) {
                ReplaceComponent rc = (ReplaceComponent)child;
                this.replaceRules.put(rc.getExpression(), rc.getValue());
            }
            if (!(child instanceof IncludeParamComponent)) continue;
            IncludeParamComponent ip = (IncludeParamComponent)child;
            this.params.put(ip.getName(), ip.getValue());
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        block2: {
            ResponseWriter writer = context.getResponseWriter();
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
            HttpEntityEnclosingRequest httpRequest = new HttpServletMediator(request, response, servletContext).getHttpRequest();
            try {
                DriverFactory.getInstance((String)this.getProvider()).render(this.getPage(), null, (Appendable)writer, httpRequest, new Renderer[]{new TemplateRenderer(this.name, this.params, this.page), new ReplaceRenderer(this.replaceRules)});
            }
            catch (HttpErrorPage re) {
                if (!this.isDisplayErrorPage()) break block2;
                writer.write(re.getMessage());
            }
        }
    }

    public String getFamily() {
        return IncludeTemplateComponent.class.getPackage().toString();
    }

    public String getName() {
        return UIComponentUtils.getParam((UIComponent)this, "name", this.name);
    }

    public String getPage() {
        return UIComponentUtils.getParam((UIComponent)this, "page", this.page);
    }

    public String getProvider() {
        return UIComponentUtils.getParam((UIComponent)this, "provider", this.provider);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public Map<String, String> getReplaceRules() {
        return this.replaceRules;
    }

    public boolean isDisplayErrorPage() {
        return UIComponentUtils.getParam((UIComponent)this, "displayErrorPage", this.displayErrorPage);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.page = (String)values[1];
        this.name = (String)values[2];
        this.provider = (String)values[3];
        this.displayErrorPage = (Boolean)values[4];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.page, this.name, this.provider, this.displayErrorPage};
        return values;
    }

    public void setDisplayErrorPage(boolean displayErrorPage) {
        this.displayErrorPage = displayErrorPage;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }
}

