/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpSelf;
import java.io.Serializable;

public class OtpErlangPort
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 4037115468007644704L;
    private final String node;
    private final int id;
    private final int creation;

    private OtpErlangPort(OtpSelf self) {
        OtpErlangPort p = self.createPort();
        this.id = p.id;
        this.creation = p.creation;
        this.node = p.node;
    }

    public OtpErlangPort(OtpInputStream buf) throws OtpErlangDecodeException {
        OtpErlangPort p = buf.read_port();
        this.node = p.node();
        this.id = p.id();
        this.creation = p.creation();
    }

    public OtpErlangPort(String node, int id, int creation) {
        this.node = node;
        this.id = id & 0xFFFFFFF;
        this.creation = creation & 3;
    }

    public int id() {
        return this.id;
    }

    public int creation() {
        return this.creation;
    }

    public String node() {
        return this.node;
    }

    public String toString() {
        return "#Port<" + this.node + "." + this.id + ">";
    }

    public void encode(OtpOutputStream buf) {
        buf.write_port(this.node, this.id, this.creation);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangPort)) {
            return false;
        }
        OtpErlangPort port = (OtpErlangPort)o;
        return this.creation == port.creation && this.id == port.id && this.node.compareTo(port.node) == 0;
    }

    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(6);
        hash.combine(this.creation);
        hash.combine(this.id, this.node.hashCode());
        return hash.valueOf();
    }
}

