/*
 * Decompiled with CFR 0.152.
 */
package org.equilibriums.aop.utils.interceptor.composite.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.equilibriums.aop.utils.interceptor.composite.ReturnValueHandler;

public class MergeCollectionReturnValueHandler
implements ReturnValueHandler {
    private Class<? extends Collection> collectionClass = null;

    public Class<? extends Collection> getCollectionClass() {
        return this.collectionClass;
    }

    public void setCollectionClass(Class<? extends Collection> collectionClass) {
        this.collectionClass = collectionClass;
    }

    @Override
    public boolean supports(Class<? extends Object> returnType, Object[] returnValues) {
        return Collection.class.isAssignableFrom(returnType);
    }

    @Override
    public Object getReturnValue(Class<? extends Object> returnType, Object[] returnValues) {
        Collection result = this.collectionClass != null ? MergeCollectionReturnValueHandler.createInstance(this.collectionClass) : new ArrayList();
        for (Object o : returnValues) {
            if (o == null) continue;
            result.addAll((Collection)o);
        }
        return result;
    }

    private static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

