/*
 * Decompiled with CFR 0.152.
 */
package org.equilibriums.aop.utils.interceptor.composite.handlers;

import org.equilibriums.aop.utils.interceptor.composite.ReturnValueHandler;

public class BooleanReturnValueHandler
implements ReturnValueHandler {
    private BooleanOperator booleanOperator = BooleanOperator.AND;

    public BooleanOperator getBooleanOperator() {
        return this.booleanOperator;
    }

    public void setBooleanOperator(BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
    }

    @Override
    public boolean supports(Class<? extends Object> returnType, Object[] returnValues) {
        return returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE);
    }

    @Override
    public Object getReturnValue(Class<? extends Object> returnType, Object[] returnValues) {
        Boolean result = null;
        for (Object o : returnValues) {
            if (o == null) continue;
            result = result == null ? (Boolean)o : this.eval(result, (Boolean)o, this.booleanOperator);
        }
        return result;
    }

    private Boolean eval(Boolean b1, Boolean b2, BooleanOperator booleanOperator) {
        if (booleanOperator == BooleanOperator.AND) {
            return b1 != false && b2 != false;
        }
        return b1 != false || b2 != false;
    }

    public static enum BooleanOperator {
        AND,
        OR;

    }
}

