/*
 * Decompiled with CFR 0.152.
 */
package org.equilibriums.aop.utils.interceptor.composite;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.equilibriums.aop.utils.interceptor.composite.ReturnValueHandler;

public class CompositeDelegateInterceptor
implements MethodInterceptor {
    private boolean proceed = false;
    private Object[] delegates = null;
    private ReturnValueHandler[] delegateReturnValueHandlers = null;

    public boolean isProceed() {
        return this.proceed;
    }

    public void setProceed(boolean proceed) {
        this.proceed = proceed;
    }

    public Object[] getDelegates() {
        return this.delegates;
    }

    public void setDelegates(Object[] delegates) {
        this.delegates = delegates;
    }

    public ReturnValueHandler[] getDelegateReturnValueHandlers() {
        return this.delegateReturnValueHandlers;
    }

    public void setDelegateReturnValueHandlers(ReturnValueHandler[] delegateReturnValueHandlers) {
        this.delegateReturnValueHandlers = delegateReturnValueHandlers;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.delegates == null || this.delegates.length == 0) {
            throw new IllegalArgumentException("delegates property needs to be specified and cannot be empty");
        }
        Method invocationMethod = invocation.getMethod();
        Object[] invocationMethodArguments = invocation.getArguments();
        Object[] returnValues = new Object[this.delegates.length];
        for (int i = 0; i < this.delegates.length; ++i) {
            returnValues[i] = invocationMethod.invoke(this.delegates[i], invocationMethodArguments);
        }
        Class<?> returnType = invocationMethod.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return null;
        }
        if (this.delegateReturnValueHandlers != null) {
            for (int i = 0; i < this.delegateReturnValueHandlers.length; ++i) {
                if (!this.delegateReturnValueHandlers[i].supports(returnType, returnValues)) continue;
                return this.delegateReturnValueHandlers[i].getReturnValue(returnType, returnValues);
            }
        }
        return this.proceed ? invocation.proceed() : null;
    }
}

