/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.junit.listeners;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.test.junit.annotations.TestLogging;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class LoggingListener
extends RunListener {
    private Map<String, String> previousLoggingMap;
    private Map<String, String> previousClassLoggingMap;
    private Map<String, String> previousPackageLoggingMap;

    public void testRunStarted(Description description) throws Exception {
        Package testClassPackage = description.getTestClass().getPackage();
        this.previousPackageLoggingMap = this.processTestLogging(testClassPackage != null ? testClassPackage.getAnnotation(TestLogging.class) : null);
        this.previousClassLoggingMap = this.processTestLogging((TestLogging)description.getAnnotation(TestLogging.class));
    }

    public void testRunFinished(Result result) throws Exception {
        this.previousClassLoggingMap = this.reset(this.previousClassLoggingMap);
        this.previousPackageLoggingMap = this.reset(this.previousPackageLoggingMap);
    }

    public void testStarted(Description description) throws Exception {
        TestLogging testLogging = (TestLogging)description.getAnnotation(TestLogging.class);
        this.previousLoggingMap = this.processTestLogging(testLogging);
    }

    public void testFinished(Description description) throws Exception {
        this.previousLoggingMap = this.reset(this.previousLoggingMap);
    }

    private static Logger resolveLogger(String loggerName) {
        if (loggerName.equalsIgnoreCase("_root")) {
            return LogManager.getRootLogger();
        }
        return LogManager.getLogger((String)loggerName);
    }

    private Map<String, String> processTestLogging(TestLogging testLogging) {
        Logger logger;
        Map<String, String> map = LoggingListener.getLoggersAndLevelsFromAnnotation(testLogging);
        if (map == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> existing = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            logger = LoggingListener.resolveLogger(entry.getKey());
            existing.put(entry.getKey(), logger.getLevel().toString());
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            logger = LoggingListener.resolveLogger(entry.getKey());
            Loggers.setLevel((Logger)logger, (String)entry.getValue());
        }
        return existing;
    }

    private static Map<String, String> getLoggersAndLevelsFromAnnotation(TestLogging testLogging) {
        String[] loggersAndLevels;
        if (testLogging == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String loggerAndLevel : loggersAndLevels = testLogging.value().split(",")) {
            String[] loggerAndLevelArray = loggerAndLevel.split(":");
            if (loggerAndLevelArray.length != 2) {
                throw new IllegalArgumentException("invalid test logging annotation [" + loggerAndLevel + "]");
            }
            map.put(loggerAndLevelArray[0], loggerAndLevelArray[1]);
        }
        return map;
    }

    private Map<String, String> reset(Map<String, String> map) {
        for (Map.Entry<String, String> previousLogger : map.entrySet()) {
            Logger logger = LoggingListener.resolveLogger(previousLogger.getKey());
            Loggers.setLevel((Logger)logger, (String)previousLogger.getValue());
        }
        return Collections.emptyMap();
    }
}

