/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.SeedUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.TestEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.test.AbstractQueryTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.test.TestSearchContext;
import org.elasticsearch.test.VersionUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractBuilderTestCase
extends ESTestCase {
    public static final String STRING_FIELD_NAME = "mapped_string";
    public static final String STRING_ALIAS_FIELD_NAME = "mapped_string_alias";
    protected static final String STRING_FIELD_NAME_2 = "mapped_string_2";
    protected static final String INT_FIELD_NAME = "mapped_int";
    protected static final String INT_ALIAS_FIELD_NAME = "mapped_int_field_alias";
    protected static final String INT_RANGE_FIELD_NAME = "mapped_int_range";
    protected static final String DOUBLE_FIELD_NAME = "mapped_double";
    protected static final String BOOLEAN_FIELD_NAME = "mapped_boolean";
    protected static final String DATE_FIELD_NAME = "mapped_date";
    protected static final String DATE_ALIAS_FIELD_NAME = "mapped_date_alias";
    protected static final String DATE_RANGE_FIELD_NAME = "mapped_date_range";
    protected static final String OBJECT_FIELD_NAME = "mapped_object";
    protected static final String GEO_POINT_FIELD_NAME = "mapped_geo_point";
    protected static final String GEO_POINT_ALIAS_FIELD_NAME = "mapped_geo_point_alias";
    protected static final String GEO_SHAPE_FIELD_NAME = "mapped_geo_shape";
    protected static final String[] MAPPED_FIELD_NAMES = new String[]{"mapped_string", "mapped_string_alias", "mapped_int", "mapped_int_range", "mapped_double", "mapped_boolean", "mapped_date", "mapped_date_range", "mapped_object", "mapped_geo_point", "mapped_geo_point_alias", "mapped_geo_shape"};
    protected static final String[] MAPPED_LEAF_FIELD_NAMES = new String[]{"mapped_string", "mapped_string_alias", "mapped_int", "mapped_int_range", "mapped_double", "mapped_boolean", "mapped_date", "mapped_date_range", "mapped_geo_point", "mapped_geo_point_alias"};
    private static final Map<String, String> ALIAS_TO_CONCRETE_FIELD_NAME = new HashMap<String, String>();
    private static ServiceHolder serviceHolder;
    private static int queryNameId;
    private static Settings nodeSettings;
    private static Index index;
    private static String[] currentTypes;
    protected static String[] randomTypes;
    private static long nowInMillis;

    protected static Index getIndex() {
        return index;
    }

    protected static String[] getCurrentTypes() {
        return currentTypes;
    }

    protected static boolean isSingleType() {
        return serviceHolder.idxSettings.isSingleType();
    }

    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.emptyList();
    }

    protected void initializeAdditionalMappings(MapperService mapperService) throws IOException {
    }

    @BeforeClass
    public static void beforeClass() {
        nodeSettings = Settings.builder().put("node.name", AbstractQueryTestCase.class.toString()).put(Environment.PATH_HOME_SETTING.getKey(), AbstractBuilderTestCase.createTempDir()).build();
        index = new Index(AbstractBuilderTestCase.randomAlphaOfLengthBetween(1, 10), "_na_");
        nowInMillis = AbstractBuilderTestCase.randomNonNegativeLong();
        switch (AbstractBuilderTestCase.random().nextInt(3)) {
            case 0: {
                currentTypes = new String[0];
                break;
            }
            default: {
                currentTypes = new String[]{"_doc"};
            }
        }
        randomTypes = AbstractBuilderTestCase.getRandomTypes();
    }

    private static String[] getRandomTypes() {
        String[] types;
        if (currentTypes.length > 0 && AbstractBuilderTestCase.randomBoolean()) {
            int numberOfQueryTypes = AbstractBuilderTestCase.randomIntBetween(1, currentTypes.length);
            types = new String[numberOfQueryTypes];
            for (int i = 0; i < numberOfQueryTypes; ++i) {
                types[i] = AbstractBuilderTestCase.randomFrom(currentTypes);
            }
        } else {
            types = AbstractBuilderTestCase.randomBoolean() ? new String[]{"_all"} : new String[]{};
        }
        return types;
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return serviceHolder.xContentRegistry;
    }

    protected NamedWriteableRegistry namedWriteableRegistry() {
        return serviceHolder.namedWriteableRegistry;
    }

    protected static String createUniqueRandomName() {
        String queryName = AbstractBuilderTestCase.randomAlphaOfLengthBetween(1, 10) + queryNameId;
        ++queryNameId;
        return queryName;
    }

    protected Settings createTestIndexSettings() {
        Version indexVersionCreated = AbstractBuilderTestCase.randomBoolean() ? Version.CURRENT : VersionUtils.randomVersionBetween(AbstractBuilderTestCase.random(), Version.V_6_0_0, Version.CURRENT);
        return Settings.builder().put("index.version.created", indexVersionCreated).build();
    }

    protected static IndexSettings indexSettings() {
        return serviceHolder.idxSettings;
    }

    protected static String expectedFieldName(String builderFieldName) {
        if (currentTypes.length == 0 || !AbstractBuilderTestCase.isSingleType()) {
            return builderFieldName;
        }
        return ALIAS_TO_CONCRETE_FIELD_NAME.getOrDefault(builderFieldName, builderFieldName);
    }

    protected Iterable<MappedFieldType> getMapping() {
        return serviceHolder.mapperService.fieldTypes();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{serviceHolder});
        serviceHolder = null;
    }

    @Before
    public void beforeTest() throws Exception {
        if (serviceHolder == null) {
            long masterSeed = SeedUtils.parseSeed((String)RandomizedTest.getContext().getRunnerSeedAsString());
            RandomizedTest.getContext().runWithPrivateRandomness(masterSeed, () -> {
                serviceHolder = new ServiceHolder(nodeSettings, this.createTestIndexSettings(), this.getPlugins(), nowInMillis, this);
                return null;
            });
        }
        ((ServiceHolder)AbstractBuilderTestCase.serviceHolder).clientInvocationHandler.delegate = this;
    }

    protected static SearchContext getSearchContext(String[] types, QueryShardContext context) {
        TestSearchContext testSearchContext = new TestSearchContext(context){

            @Override
            public MapperService mapperService() {
                return serviceHolder.mapperService;
            }

            @Override
            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
                return (IFD)serviceHolder.indexFieldDataService.getForField(fieldType);
            }
        };
        testSearchContext.getQueryShardContext().setTypes(types);
        return testSearchContext;
    }

    @After
    public void afterTest() {
        ((ServiceHolder)AbstractBuilderTestCase.serviceHolder).clientInvocationHandler.delegate = null;
    }

    protected GetResponse executeGet(GetRequest getRequest) {
        throw new UnsupportedOperationException("this test can't handle GET requests");
    }

    protected MultiTermVectorsResponse executeMultiTermVectors(MultiTermVectorsRequest mtvRequest) {
        throw new UnsupportedOperationException("this test can't handle MultiTermVector requests");
    }

    protected static QueryShardContext createShardContext(IndexReader reader) {
        return serviceHolder.createShardContext(reader);
    }

    protected static QueryShardContext createShardContext() {
        return AbstractBuilderTestCase.createShardContext(null);
    }

    static {
        ALIAS_TO_CONCRETE_FIELD_NAME.put(STRING_ALIAS_FIELD_NAME, STRING_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(INT_ALIAS_FIELD_NAME, INT_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(DATE_ALIAS_FIELD_NAME, DATE_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(GEO_POINT_ALIAS_FIELD_NAME, GEO_POINT_FIELD_NAME);
        queryNameId = 0;
    }

    private static class ServiceHolder
    implements Closeable {
        private final IndexFieldDataService indexFieldDataService;
        private final SearchModule searchModule;
        private final NamedWriteableRegistry namedWriteableRegistry;
        private final NamedXContentRegistry xContentRegistry;
        private final ClientInvocationHandler clientInvocationHandler = new ClientInvocationHandler();
        private final IndexSettings idxSettings;
        private final SimilarityService similarityService;
        private final MapperService mapperService;
        private final BitsetFilterCache bitsetFilterCache;
        private final ScriptService scriptService;
        private final Client client;
        private final long nowInMillis;

        ServiceHolder(Settings nodeSettings, Settings indexSettings, Collection<Class<? extends Plugin>> plugins, long nowInMillis, AbstractBuilderTestCase testCase) throws IOException {
            Environment env = InternalSettingsPreparer.prepareEnvironment((Settings)nodeSettings, null);
            this.nowInMillis = nowInMillis;
            PluginsService pluginsService = new PluginsService(nodeSettings, null, env.modulesFile(), env.pluginsFile(), plugins);
            this.client = (Client)Proxy.newProxyInstance(Client.class.getClassLoader(), new Class[]{Client.class}, (InvocationHandler)this.clientInvocationHandler);
            ScriptModule scriptModule = this.createScriptModule(pluginsService.filterPlugins(ScriptPlugin.class));
            List additionalSettings = pluginsService.getPluginSettings();
            SettingsModule settingsModule = new SettingsModule(nodeSettings, additionalSettings, pluginsService.getPluginSettingsFilter(), Collections.emptySet());
            this.searchModule = new SearchModule(nodeSettings, false, pluginsService.filterPlugins(SearchPlugin.class));
            IndicesModule indicesModule = new IndicesModule(pluginsService.filterPlugins(MapperPlugin.class));
            ArrayList entries = new ArrayList();
            entries.addAll(indicesModule.getNamedWriteables());
            entries.addAll(this.searchModule.getNamedWriteables());
            this.namedWriteableRegistry = new NamedWriteableRegistry(entries);
            this.xContentRegistry = new NamedXContentRegistry(Stream.of(this.searchModule.getNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            IndexScopedSettings indexScopedSettings = settingsModule.getIndexScopedSettings();
            this.idxSettings = IndexSettingsModule.newIndexSettings(index, indexSettings, indexScopedSettings);
            AnalysisModule analysisModule = new AnalysisModule(TestEnvironment.newEnvironment(nodeSettings), Collections.emptyList());
            IndexAnalyzers indexAnalyzers = analysisModule.getAnalysisRegistry().build(this.idxSettings);
            this.scriptService = scriptModule.getScriptService();
            this.similarityService = new SimilarityService(this.idxSettings, null, Collections.emptyMap());
            MapperRegistry mapperRegistry = indicesModule.getMapperRegistry();
            this.mapperService = new MapperService(this.idxSettings, indexAnalyzers, this.xContentRegistry, this.similarityService, mapperRegistry, () -> this.createShardContext(null));
            IndicesFieldDataCache indicesFieldDataCache = new IndicesFieldDataCache(nodeSettings, new IndexFieldDataCache.Listener(){});
            this.indexFieldDataService = new IndexFieldDataService(this.idxSettings, indicesFieldDataCache, (CircuitBreakerService)new NoneCircuitBreakerService(), this.mapperService);
            this.bitsetFilterCache = new BitsetFilterCache(this.idxSettings, new BitsetFilterCache.Listener(){

                public void onCache(ShardId shardId, Accountable accountable) {
                }

                public void onRemoval(ShardId shardId, Accountable accountable) {
                }
            });
            for (String type : currentTypes) {
                this.mapperService.merge(type, new CompressedXContent(Strings.toString((XContentBuilder)PutMappingRequest.buildFromSimplifiedDef((String)type, (Object[])new Object[]{AbstractBuilderTestCase.STRING_FIELD_NAME, "type=text", AbstractBuilderTestCase.STRING_FIELD_NAME_2, "type=keyword", AbstractBuilderTestCase.INT_FIELD_NAME, "type=integer", AbstractBuilderTestCase.INT_RANGE_FIELD_NAME, "type=integer_range", AbstractBuilderTestCase.DOUBLE_FIELD_NAME, "type=double", AbstractBuilderTestCase.BOOLEAN_FIELD_NAME, "type=boolean", AbstractBuilderTestCase.DATE_FIELD_NAME, "type=date", AbstractBuilderTestCase.DATE_RANGE_FIELD_NAME, "type=date_range", AbstractBuilderTestCase.OBJECT_FIELD_NAME, "type=object", AbstractBuilderTestCase.GEO_POINT_FIELD_NAME, "type=geo_point", AbstractBuilderTestCase.GEO_SHAPE_FIELD_NAME, "type=geo_shape"}))), MapperService.MergeReason.MAPPING_UPDATE, false);
                if (this.idxSettings.isSingleType()) {
                    this.mapperService.merge(type, new CompressedXContent(Strings.toString((XContentBuilder)PutMappingRequest.buildFromSimplifiedDef((String)type, (Object[])new Object[]{AbstractBuilderTestCase.STRING_ALIAS_FIELD_NAME, "type=alias,path=mapped_string", AbstractBuilderTestCase.INT_ALIAS_FIELD_NAME, "type=alias,path=mapped_int", AbstractBuilderTestCase.DATE_ALIAS_FIELD_NAME, "type=alias,path=mapped_date", AbstractBuilderTestCase.GEO_POINT_ALIAS_FIELD_NAME, "type=alias,path=mapped_geo_point"}))), MapperService.MergeReason.MAPPING_UPDATE, false);
                } else {
                    this.mapperService.merge(type, new CompressedXContent(Strings.toString((XContentBuilder)PutMappingRequest.buildFromSimplifiedDef((String)type, (Object[])new Object[]{AbstractBuilderTestCase.STRING_ALIAS_FIELD_NAME, "type=text", AbstractBuilderTestCase.INT_ALIAS_FIELD_NAME, "type=integer", AbstractBuilderTestCase.DATE_ALIAS_FIELD_NAME, "type=date", AbstractBuilderTestCase.GEO_POINT_ALIAS_FIELD_NAME, "type=geo_point"}))), MapperService.MergeReason.MAPPING_UPDATE, false);
                }
                this.mapperService.merge(type, new CompressedXContent("{\"properties\":{\"mapped_object\":{\"type\":\"object\",\"properties\":{\"mapped_date\":{\"type\":\"date\"},\"mapped_int\":{\"type\":\"integer\"}}}}}"), MapperService.MergeReason.MAPPING_UPDATE, false);
            }
            testCase.initializeAdditionalMappings(this.mapperService);
        }

        @Override
        public void close() throws IOException {
        }

        QueryShardContext createShardContext(IndexReader reader) {
            return new QueryShardContext(0, this.idxSettings, this.bitsetFilterCache, IndexSearcher::new, (arg_0, arg_1) -> ((IndexFieldDataService)this.indexFieldDataService).getForField(arg_0, arg_1), this.mapperService, this.similarityService, this.scriptService, this.xContentRegistry, this.namedWriteableRegistry, this.client, reader, () -> this.nowInMillis, null);
        }

        ScriptModule createScriptModule(List<ScriptPlugin> scriptPlugins) {
            if (scriptPlugins == null || scriptPlugins.isEmpty()) {
                return ESTestCase.newTestScriptModule();
            }
            return new ScriptModule(Settings.EMPTY, scriptPlugins);
        }
    }

    private static class ClientInvocationHandler
    implements InvocationHandler {
        AbstractBuilderTestCase delegate;

        private ClientInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
            if (method.equals(Client.class.getMethod("get", GetRequest.class, ActionListener.class))) {
                GetResponse getResponse = this.delegate.executeGet((GetRequest)args[0]);
                ActionListener listener = (ActionListener)args[1];
                if (ESTestCase.randomBoolean()) {
                    listener.onResponse((Object)getResponse);
                } else {
                    new Thread(() -> listener.onResponse((Object)getResponse)).start();
                }
                return null;
            }
            if (method.equals(Client.class.getMethod("multiTermVectors", MultiTermVectorsRequest.class))) {
                return new PlainActionFuture<MultiTermVectorsResponse>(){

                    public MultiTermVectorsResponse get() throws InterruptedException, ExecutionException {
                        return delegate.executeMultiTermVectors((MultiTermVectorsRequest)args[0]);
                    }
                };
            }
            if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
                return "MockClient";
            }
            throw new UnsupportedOperationException("this test can't handle calls to: " + method);
        }
    }
}

