/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.transport.nio.InboundChannelBuffer;
import org.elasticsearch.transport.nio.SocketSelector;
import org.elasticsearch.transport.nio.channel.AbstractNioChannel;
import org.elasticsearch.transport.nio.channel.ReadContext;
import org.elasticsearch.transport.nio.channel.WriteContext;

public class NioSocketChannel
extends AbstractNioChannel<SocketChannel> {
    private final InetSocketAddress remoteAddress;
    private final CompletableFuture<Void> connectContext = new CompletableFuture();
    private final SocketSelector socketSelector;
    private final AtomicBoolean contextsSet = new AtomicBoolean(false);
    private WriteContext writeContext;
    private ReadContext readContext;
    private BiConsumer<NioSocketChannel, Exception> exceptionContext;
    private Exception connectException;

    public NioSocketChannel(SocketChannel socketChannel, SocketSelector selector) throws IOException {
        super(socketChannel, selector);
        this.remoteAddress = (InetSocketAddress)socketChannel.getRemoteAddress();
        this.socketSelector = selector;
    }

    @Override
    public void closeFromSelector() throws IOException {
        assert (this.socketSelector.isOnCurrentThread()) : "Should only call from selector thread";
        if (this.writeContext.hasQueuedWriteOps()) {
            this.writeContext.clearQueuedWriteOps(new ClosedChannelException());
        }
        this.readContext.close();
        super.closeFromSelector();
    }

    @Override
    public SocketSelector getSelector() {
        return this.socketSelector;
    }

    public int write(ByteBuffer[] buffers) throws IOException {
        if (buffers.length == 1) {
            return ((SocketChannel)this.socketChannel).write(buffers[0]);
        }
        return (int)((SocketChannel)this.socketChannel).write(buffers);
    }

    public int read(InboundChannelBuffer buffer) throws IOException {
        int bytesRead = (int)((SocketChannel)this.socketChannel).read(buffer.sliceBuffersFrom(buffer.getIndex()));
        if (bytesRead == -1) {
            return bytesRead;
        }
        buffer.incrementIndex(bytesRead);
        return bytesRead;
    }

    public void setContexts(ReadContext readContext, WriteContext writeContext, BiConsumer<NioSocketChannel, Exception> exceptionContext) {
        if (!this.contextsSet.compareAndSet(false, true)) {
            throw new IllegalStateException("Contexts on this channel were already set. They should only be once.");
        }
        this.readContext = readContext;
        this.writeContext = writeContext;
        this.exceptionContext = exceptionContext;
    }

    public WriteContext getWriteContext() {
        return this.writeContext;
    }

    public ReadContext getReadContext() {
        return this.readContext;
    }

    public BiConsumer<NioSocketChannel, Exception> getExceptionContext() {
        return this.exceptionContext;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean isConnectComplete() {
        return this.isConnectComplete0();
    }

    public boolean isWritable() {
        return !this.isClosing.get();
    }

    public boolean isReadable() {
        return !this.isClosing.get();
    }

    public boolean finishConnect() throws IOException {
        if (this.isConnectComplete0()) {
            return true;
        }
        if (this.connectContext.isCompletedExceptionally()) {
            Exception exception = this.connectException;
            if (exception == null) {
                throw new AssertionError((Object)"Should have received connection exception");
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (RuntimeException)exception;
        }
        boolean isConnected = ((SocketChannel)this.socketChannel).isConnected();
        if (!isConnected) {
            isConnected = this.internalFinish();
        }
        if (isConnected) {
            this.connectContext.complete(null);
        }
        return isConnected;
    }

    public void addConnectListener(ActionListener<Void> listener) {
        this.connectContext.whenComplete(ActionListener.toBiConsumer(listener));
    }

    public String toString() {
        return "NioSocketChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.remoteAddress + '}';
    }

    private boolean internalFinish() throws IOException {
        try {
            return ((SocketChannel)this.socketChannel).finishConnect();
        }
        catch (IOException | RuntimeException e) {
            this.connectException = e;
            this.connectContext.completeExceptionally(e);
            throw e;
        }
    }

    private boolean isConnectComplete0() {
        return this.connectContext.isDone() && !this.connectContext.isCompletedExceptionally();
    }
}

