/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.discovery;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.zen.PingContextProvider;
import org.elasticsearch.discovery.zen.SettingsBasedHostsProvider;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.ZenPing;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.discovery.MockUncasedHostProvider;
import org.elasticsearch.test.discovery.MockZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TestZenDiscovery
extends ZenDiscovery {
    public static final Setting<Boolean> USE_MOCK_PINGS = Setting.boolSetting((String)"discovery.zen.use_mock_pings", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    private TestZenDiscovery(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, UnicastHostsProvider hostsProvider, AllocationService allocationService) {
        super(settings, threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, hostsProvider, allocationService, Collections.emptyList());
    }

    protected ZenPing newZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, UnicastHostsProvider hostsProvider) {
        if (((Boolean)USE_MOCK_PINGS.get(settings)).booleanValue()) {
            return new MockZenPing(settings, (PingContextProvider)this);
        }
        return super.newZenPing(settings, threadPool, transportService, hostsProvider);
    }

    public ZenPing getZenPing() {
        return this.zenPing;
    }

    public static class TestPlugin
    extends Plugin
    implements DiscoveryPlugin {
        protected final Settings settings;
        private final SetOnce<MockUncasedHostProvider> unicastHostProvider = new SetOnce();

        public TestPlugin(Settings settings) {
            this.settings = settings;
        }

        public Map<String, Supplier<Discovery>> getDiscoveryTypes(ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, UnicastHostsProvider hostsProvider, AllocationService allocationService) {
            return Collections.singletonMap("test-zen", () -> new TestZenDiscovery(Settings.builder().put(this.settings).putList(SettingsBasedHostsProvider.DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING.getKey(), new String[0]).build(), threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, hostsProvider, allocationService));
        }

        public Map<String, Supplier<UnicastHostsProvider>> getZenHostsProviders(TransportService transportService, NetworkService networkService) {
            Supplier<UnicastHostsProvider> supplier = (Boolean)USE_MOCK_PINGS.get(this.settings) != false ? () -> hostsResolver -> {
                throw new UnsupportedOperationException();
            } : () -> {
                this.unicastHostProvider.set((Object)new MockUncasedHostProvider(() -> ((TransportService)transportService).getLocalNode(), (ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(this.settings)));
                return (UnicastHostsProvider)this.unicastHostProvider.get();
            };
            return Collections.singletonMap("test-zen", supplier);
        }

        public List<Setting<?>> getSettings() {
            return Collections.singletonList(USE_MOCK_PINGS);
        }

        public Settings additionalSettings() {
            return Settings.builder().put(DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey(), "test-zen").put(DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.getKey(), "test-zen").putList(SettingsBasedHostsProvider.DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING.getKey(), new String[0]).build();
        }

        public void close() throws IOException {
            super.close();
            if (this.unicastHostProvider.get() != null) {
                ((MockUncasedHostProvider)this.unicastHostProvider.get()).close();
            }
        }
    }
}

