/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.test.ESTestCase;

public final class RandomObjects {
    private RandomObjects() {
    }

    public static Tuple<List<Object>, List<Object>> randomStoredFieldValues(Random random, XContentType xContentType) {
        int numValues = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5);
        ArrayList<Object> originalValues = new ArrayList<Object>();
        ArrayList<Object> expectedParsedValues = new ArrayList<Object>();
        int dataType = RandomNumbers.randomIntBetween((Random)random, (int)0, (int)8);
        block11: for (int i = 0; i < numValues; ++i) {
            switch (dataType) {
                case 0: {
                    long randomLong = random.nextLong();
                    originalValues.add(randomLong);
                    expectedParsedValues.add(randomLong);
                    continue block11;
                }
                case 1: {
                    int randomInt = random.nextInt();
                    originalValues.add(randomInt);
                    expectedParsedValues.add(randomInt);
                    continue block11;
                }
                case 2: {
                    Short randomShort = (short)random.nextInt();
                    originalValues.add(randomShort);
                    expectedParsedValues.add(randomShort.intValue());
                    continue block11;
                }
                case 3: {
                    Byte randomByte = (byte)random.nextInt();
                    originalValues.add(randomByte);
                    expectedParsedValues.add(randomByte.intValue());
                    continue block11;
                }
                case 4: {
                    double randomDouble = random.nextDouble();
                    originalValues.add(randomDouble);
                    expectedParsedValues.add(randomDouble);
                    continue block11;
                }
                case 5: {
                    Float randomFloat = Float.valueOf(random.nextFloat());
                    originalValues.add(randomFloat);
                    if (xContentType == XContentType.CBOR) {
                        expectedParsedValues.add(randomFloat);
                        continue block11;
                    }
                    if (xContentType == XContentType.SMILE) {
                        expectedParsedValues.add(randomFloat.doubleValue());
                        continue block11;
                    }
                    expectedParsedValues.add(Double.parseDouble(randomFloat.toString()));
                    continue block11;
                }
                case 6: {
                    boolean randomBoolean = random.nextBoolean();
                    originalValues.add(randomBoolean);
                    expectedParsedValues.add(randomBoolean);
                    continue block11;
                }
                case 7: {
                    String randomString = random.nextBoolean() ? RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)3, (int)10) : RandomStrings.randomUnicodeOfLengthBetween((Random)random, (int)3, (int)10);
                    originalValues.add(randomString);
                    expectedParsedValues.add(randomString);
                    continue block11;
                }
                case 8: {
                    byte[] randomBytes = RandomStrings.randomUnicodeOfLengthBetween((Random)random, (int)10, (int)50).getBytes(StandardCharsets.UTF_8);
                    BytesArray randomBytesArray = new BytesArray(randomBytes);
                    originalValues.add(randomBytesArray);
                    if (xContentType == XContentType.JSON || xContentType == XContentType.YAML) {
                        expectedParsedValues.add(Base64.getEncoder().encodeToString(randomBytes));
                        continue block11;
                    }
                    expectedParsedValues.add(randomBytesArray);
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return Tuple.tuple(originalValues, expectedParsedValues);
    }

    public static BytesReference randomSource(Random random) {
        return RandomObjects.randomSource(random, (XContentType)RandomPicks.randomFrom((Random)random, (Object[])XContentType.values()));
    }

    public static BytesReference randomSource(Random random, XContentType xContentType) {
        return RandomObjects.randomSource(random, xContentType, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BytesReference randomSource(Random random, XContentType xContentType, int minNumFields) {
        try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);){
            builder.startObject();
            RandomObjects.addFields(random, builder, minNumFields, 0);
            builder.endObject();
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addFields(Random random, XContentBuilder builder, int minNumFields, int currentDepth) throws IOException {
        int numFields = RandomNumbers.randomIntBetween((Random)random, (int)minNumFields, (int)5);
        for (int i = 0; i < numFields; ++i) {
            if (currentDepth < 5 && random.nextInt(100) >= 70) {
                if (random.nextBoolean()) {
                    builder.startObject(RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)6, (int)10));
                    RandomObjects.addFields(random, builder, minNumFields, currentDepth + 1);
                    builder.endObject();
                    continue;
                }
                builder.startArray(RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)6, (int)10));
                int numElements = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5);
                boolean object = random.nextBoolean();
                int dataType = -1;
                if (!object) {
                    dataType = RandomObjects.randomDataType(random);
                }
                for (int j = 0; j < numElements; ++j) {
                    if (object) {
                        builder.startObject();
                        RandomObjects.addFields(random, builder, minNumFields, 5);
                        builder.endObject();
                        continue;
                    }
                    builder.value(RandomObjects.randomFieldValue(random, dataType));
                }
                builder.endArray();
                continue;
            }
            builder.field(RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)6, (int)10), RandomObjects.randomFieldValue(random, RandomObjects.randomDataType(random)));
        }
    }

    private static int randomDataType(Random random) {
        return RandomNumbers.randomIntBetween((Random)random, (int)0, (int)3);
    }

    private static Object randomFieldValue(Random random, int dataType) {
        switch (dataType) {
            case 0: {
                return RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)3, (int)10);
            }
            case 1: {
                return RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)3, (int)10);
            }
            case 2: {
                return random.nextLong();
            }
            case 3: {
                return random.nextDouble();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Tuple<ReplicationResponse.ShardInfo, ReplicationResponse.ShardInfo> randomShardInfo(Random random) {
        return RandomObjects.randomShardInfo(random, random.nextBoolean());
    }

    public static Tuple<ReplicationResponse.ShardInfo, ReplicationResponse.ShardInfo> randomShardInfo(Random random, boolean withShardFailures) {
        int total = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
        if (!withShardFailures) {
            return Tuple.tuple((Object)new ReplicationResponse.ShardInfo(total, total, new ReplicationResponse.ShardInfo.Failure[0]), (Object)new ReplicationResponse.ShardInfo(total, total, new ReplicationResponse.ShardInfo.Failure[0]));
        }
        int successful = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)Math.max(1, total - 1));
        int failures = Math.max(1, total - successful);
        ReplicationResponse.ShardInfo.Failure[] actualFailures = new ReplicationResponse.ShardInfo.Failure[failures];
        ReplicationResponse.ShardInfo.Failure[] expectedFailures = new ReplicationResponse.ShardInfo.Failure[failures];
        for (int i = 0; i < failures; ++i) {
            Tuple<ReplicationResponse.ShardInfo.Failure, ReplicationResponse.ShardInfo.Failure> failure = RandomObjects.randomShardInfoFailure(random);
            actualFailures[i] = (ReplicationResponse.ShardInfo.Failure)failure.v1();
            expectedFailures[i] = (ReplicationResponse.ShardInfo.Failure)failure.v2();
        }
        return Tuple.tuple((Object)new ReplicationResponse.ShardInfo(total, successful, actualFailures), (Object)new ReplicationResponse.ShardInfo(total, successful, expectedFailures));
    }

    private static Tuple<ReplicationResponse.ShardInfo.Failure, ReplicationResponse.ShardInfo.Failure> randomShardInfoFailure(Random random) {
        ElasticsearchException expectedException;
        Object actualException;
        String index = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
        String indexUuid = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
        int shardId = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
        String nodeId = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
        RestStatus status = ESTestCase.randomFrom(random, new RestStatus[]{RestStatus.INTERNAL_SERVER_ERROR, RestStatus.FORBIDDEN, RestStatus.NOT_FOUND});
        boolean primary = random.nextBoolean();
        ShardId shard = new ShardId(index, indexUuid, shardId);
        int type = RandomNumbers.randomIntBetween((Random)random, (int)0, (int)3);
        switch (type) {
            case 0: {
                actualException = new ClusterBlockException(Collections.singleton(DiscoverySettings.NO_MASTER_BLOCK_WRITES));
                expectedException = new ElasticsearchException("Elasticsearch exception [type=cluster_block_exception, reason=blocked by: [SERVICE_UNAVAILABLE/2/no master];]", new Object[0]);
                break;
            }
            case 1: {
                actualException = new ShardNotFoundException(shard);
                expectedException = new ElasticsearchException("Elasticsearch exception [type=shard_not_found_exception, reason=no such shard]", new Object[0]);
                expectedException.setShard(shard);
                break;
            }
            case 2: {
                actualException = new IllegalArgumentException("Closed resource", new RuntimeException("Resource"));
                expectedException = new ElasticsearchException("Elasticsearch exception [type=illegal_argument_exception, reason=Closed resource]", (Throwable)new ElasticsearchException("Elasticsearch exception [type=runtime_exception, reason=Resource]", new Object[0]), new Object[0]);
                break;
            }
            case 3: {
                actualException = new IndexShardRecoveringException(shard);
                expectedException = new ElasticsearchException("Elasticsearch exception [type=index_shard_recovering_exception, reason=CurrentState[RECOVERING] Already recovering]", new Object[0]);
                expectedException.setShard(shard);
                break;
            }
            default: {
                throw new UnsupportedOperationException("No randomized exceptions generated for type [" + type + "]");
            }
        }
        ReplicationResponse.ShardInfo.Failure actual = new ReplicationResponse.ShardInfo.Failure(shard, nodeId, (Exception)actualException, status, primary);
        ReplicationResponse.ShardInfo.Failure expected = new ReplicationResponse.ShardInfo.Failure(new ShardId(index, "_na_", shardId), nodeId, (Exception)expectedException, status, primary);
        return Tuple.tuple((Object)actual, (Object)expected);
    }
}

