/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.index.analysis.HunspellTokenFilterFactory;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.PreConfiguredCharFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenizer;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.StandardTokenFilterFactory;
import org.elasticsearch.index.analysis.StandardTokenizerFactory;
import org.elasticsearch.index.analysis.StopTokenFilterFactory;
import org.elasticsearch.index.analysis.SynonymGraphTokenFilterFactory;
import org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AnalysisFactoryTestCase
extends ESTestCase {
    private static final Pattern UNDERSCORE_THEN_ANYTHING = Pattern.compile("_(.)");
    static final Map<String, Class<?>> KNOWN_TOKENIZERS = new MapBuilder().put((Object)"classic", MovedToAnalysisCommon.class).put((Object)"edgengram", MovedToAnalysisCommon.class).put((Object)"keyword", MovedToAnalysisCommon.class).put((Object)"letter", MovedToAnalysisCommon.class).put((Object)"lowercase", MovedToAnalysisCommon.class).put((Object)"ngram", MovedToAnalysisCommon.class).put((Object)"pathhierarchy", MovedToAnalysisCommon.class).put((Object)"pattern", MovedToAnalysisCommon.class).put((Object)"simplepattern", MovedToAnalysisCommon.class).put((Object)"simplepatternsplit", MovedToAnalysisCommon.class).put((Object)"standard", StandardTokenizerFactory.class).put((Object)"thai", MovedToAnalysisCommon.class).put((Object)"uax29urlemail", MovedToAnalysisCommon.class).put((Object)"whitespace", MovedToAnalysisCommon.class).put((Object)"wikipedia", Void.class).immutableMap();
    static final Map<String, Class<?>> KNOWN_TOKENFILTERS = new MapBuilder().put((Object)"apostrophe", MovedToAnalysisCommon.class).put((Object)"arabicnormalization", MovedToAnalysisCommon.class).put((Object)"arabicstem", MovedToAnalysisCommon.class).put((Object)"asciifolding", MovedToAnalysisCommon.class).put((Object)"bengalinormalization", MovedToAnalysisCommon.class).put((Object)"bengalistem", MovedToAnalysisCommon.class).put((Object)"brazilianstem", MovedToAnalysisCommon.class).put((Object)"bulgarianstem", MovedToAnalysisCommon.class).put((Object)"cjkbigram", MovedToAnalysisCommon.class).put((Object)"cjkwidth", MovedToAnalysisCommon.class).put((Object)"classic", MovedToAnalysisCommon.class).put((Object)"commongrams", MovedToAnalysisCommon.class).put((Object)"commongramsquery", MovedToAnalysisCommon.class).put((Object)"czechstem", MovedToAnalysisCommon.class).put((Object)"decimaldigit", MovedToAnalysisCommon.class).put((Object)"delimitedpayload", MovedToAnalysisCommon.class).put((Object)"dictionarycompoundword", MovedToAnalysisCommon.class).put((Object)"edgengram", MovedToAnalysisCommon.class).put((Object)"elision", MovedToAnalysisCommon.class).put((Object)"englishminimalstem", MovedToAnalysisCommon.class).put((Object)"englishpossessive", MovedToAnalysisCommon.class).put((Object)"finnishlightstem", MovedToAnalysisCommon.class).put((Object)"fixedshingle", MovedToAnalysisCommon.class).put((Object)"frenchlightstem", MovedToAnalysisCommon.class).put((Object)"frenchminimalstem", MovedToAnalysisCommon.class).put((Object)"galicianminimalstem", MovedToAnalysisCommon.class).put((Object)"galicianstem", MovedToAnalysisCommon.class).put((Object)"germanstem", MovedToAnalysisCommon.class).put((Object)"germanlightstem", MovedToAnalysisCommon.class).put((Object)"germanminimalstem", MovedToAnalysisCommon.class).put((Object)"germannormalization", MovedToAnalysisCommon.class).put((Object)"greeklowercase", MovedToAnalysisCommon.class).put((Object)"greekstem", MovedToAnalysisCommon.class).put((Object)"hindinormalization", MovedToAnalysisCommon.class).put((Object)"hindistem", MovedToAnalysisCommon.class).put((Object)"hungarianlightstem", MovedToAnalysisCommon.class).put((Object)"hunspellstem", HunspellTokenFilterFactory.class).put((Object)"hyphenationcompoundword", MovedToAnalysisCommon.class).put((Object)"indicnormalization", MovedToAnalysisCommon.class).put((Object)"irishlowercase", MovedToAnalysisCommon.class).put((Object)"indonesianstem", MovedToAnalysisCommon.class).put((Object)"italianlightstem", MovedToAnalysisCommon.class).put((Object)"keepword", MovedToAnalysisCommon.class).put((Object)"keywordmarker", MovedToAnalysisCommon.class).put((Object)"kstem", MovedToAnalysisCommon.class).put((Object)"latvianstem", MovedToAnalysisCommon.class).put((Object)"length", MovedToAnalysisCommon.class).put((Object)"limittokencount", MovedToAnalysisCommon.class).put((Object)"lowercase", MovedToAnalysisCommon.class).put((Object)"ngram", MovedToAnalysisCommon.class).put((Object)"norwegianlightstem", MovedToAnalysisCommon.class).put((Object)"norwegianminimalstem", MovedToAnalysisCommon.class).put((Object)"patterncapturegroup", MovedToAnalysisCommon.class).put((Object)"patternreplace", MovedToAnalysisCommon.class).put((Object)"persiannormalization", MovedToAnalysisCommon.class).put((Object)"porterstem", MovedToAnalysisCommon.class).put((Object)"portuguesestem", MovedToAnalysisCommon.class).put((Object)"portugueselightstem", MovedToAnalysisCommon.class).put((Object)"portugueseminimalstem", MovedToAnalysisCommon.class).put((Object)"reversestring", MovedToAnalysisCommon.class).put((Object)"russianlightstem", MovedToAnalysisCommon.class).put((Object)"scandinavianfolding", MovedToAnalysisCommon.class).put((Object)"scandinaviannormalization", MovedToAnalysisCommon.class).put((Object)"serbiannormalization", MovedToAnalysisCommon.class).put((Object)"shingle", ShingleTokenFilterFactory.class).put((Object)"minhash", MovedToAnalysisCommon.class).put((Object)"snowballporter", MovedToAnalysisCommon.class).put((Object)"soraninormalization", MovedToAnalysisCommon.class).put((Object)"soranistem", MovedToAnalysisCommon.class).put((Object)"spanishlightstem", MovedToAnalysisCommon.class).put((Object)"standard", StandardTokenFilterFactory.class).put((Object)"stemmeroverride", MovedToAnalysisCommon.class).put((Object)"stop", StopTokenFilterFactory.class).put((Object)"swedishlightstem", MovedToAnalysisCommon.class).put((Object)"synonym", SynonymTokenFilterFactory.class).put((Object)"synonymgraph", SynonymGraphTokenFilterFactory.class).put((Object)"trim", MovedToAnalysisCommon.class).put((Object)"truncate", MovedToAnalysisCommon.class).put((Object)"turkishlowercase", MovedToAnalysisCommon.class).put((Object)"type", MovedToAnalysisCommon.class).put((Object)"uppercase", MovedToAnalysisCommon.class).put((Object)"worddelimiter", MovedToAnalysisCommon.class).put((Object)"worddelimitergraph", MovedToAnalysisCommon.class).put((Object)"flattengraph", MovedToAnalysisCommon.class).put((Object)"suggeststop", Void.class).put((Object)"capitalization", Void.class).put((Object)"codepointcount", Void.class).put((Object)"hyphenatedwords", Void.class).put((Object)"keywordrepeat", Void.class).put((Object)"limittokenoffset", Void.class).put((Object)"limittokenposition", Void.class).put((Object)"numericpayload", Void.class).put((Object)"removeduplicates", Void.class).put((Object)"tokenoffsetpayload", Void.class).put((Object)"typeaspayload", Void.class).put((Object)"typeassynonym", Void.class).put((Object)"fingerprint", Void.class).put((Object)"daterecognizer", Void.class).put((Object)"fixbrokenoffsets", Void.class).put((Object)"delimitedtermfrequency", Void.class).put((Object)"protectedterm", Void.class).put((Object)"concatenategraph", Void.class).immutableMap();
    static final Map<String, Class<?>> KNOWN_CHARFILTERS = new MapBuilder().put((Object)"htmlstrip", MovedToAnalysisCommon.class).put((Object)"mapping", MovedToAnalysisCommon.class).put((Object)"patternreplace", MovedToAnalysisCommon.class).put((Object)"persian", Void.class).immutableMap();
    private final AnalysisPlugin plugin;

    private static String toCamelCase(String s) {
        java.util.regex.Matcher m = UNDERSCORE_THEN_ANYTHING.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    public AnalysisFactoryTestCase(AnalysisPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin is required. use an empty plugin for core");
    }

    protected Map<String, Class<?>> getCharFilters() {
        return KNOWN_CHARFILTERS;
    }

    protected Map<String, Class<?>> getTokenFilters() {
        return KNOWN_TOKENFILTERS;
    }

    protected Map<String, Class<?>> getTokenizers() {
        return KNOWN_TOKENIZERS;
    }

    protected Map<String, Class<?>> getPreConfiguredTokenFilters() {
        HashMap filters = new HashMap();
        filters.put("standard", null);
        filters.put("lowercase", null);
        return filters;
    }

    protected Map<String, Class<?>> getPreConfiguredTokenizers() {
        HashMap tokenizers = new HashMap();
        for (PreBuiltTokenizers tokenizer : PreBuiltTokenizers.values()) {
            tokenizers.put(tokenizer.name().toLowerCase(Locale.ROOT), null);
        }
        return tokenizers;
    }

    public Map<String, Class<?>> getPreConfiguredCharFilters() {
        return Collections.emptyMap();
    }

    public void testTokenizers() {
        TreeSet missing = new TreeSet(TokenizerFactory.availableTokenizers());
        missing.removeAll(this.getTokenizers().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new tokenizers found, please update KNOWN_TOKENIZERS: " + ((Object)missing).toString()), (boolean)missing.isEmpty());
    }

    public void testCharFilters() {
        TreeSet missing = new TreeSet(CharFilterFactory.availableCharFilters());
        missing.removeAll(this.getCharFilters().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new charfilters found, please update KNOWN_CHARFILTERS: " + ((Object)missing).toString()), (boolean)missing.isEmpty());
    }

    public void testTokenFilters() {
        TreeSet missing = new TreeSet(TokenFilterFactory.availableTokenFilters());
        missing.removeAll(this.getTokenFilters().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new tokenfilters found, please update KNOWN_TOKENFILTERS: " + ((Object)missing).toString()), (boolean)missing.isEmpty());
    }

    public void testMultiTermAware() {
        HashSet expected = new HashSet();
        for (Map.Entry<String, Class<?>> entry : this.getTokenizers().entrySet()) {
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(TokenizerFactory.lookupClass((String)entry.getKey()))) continue;
            expected.add(entry.getValue());
        }
        for (Map.Entry<String, Class<?>> entry : this.getTokenFilters().entrySet()) {
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(TokenFilterFactory.lookupClass((String)entry.getKey()))) continue;
            expected.add(entry.getValue());
        }
        for (Map.Entry<String, Class<?>> entry : this.getCharFilters().entrySet()) {
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(CharFilterFactory.lookupClass((String)entry.getKey()))) continue;
            expected.add(entry.getValue());
        }
        expected.remove(Void.class);
        expected.remove(MovedToAnalysisCommon.class);
        expected.remove(Deprecated.class);
        HashSet actual = new HashSet();
        for (Class<?> clazz : this.getTokenizers().values()) {
            if (!MultiTermAwareComponent.class.isAssignableFrom(clazz)) continue;
            actual.add(clazz);
        }
        for (Class<?> clazz : this.getTokenFilters().values()) {
            if (!MultiTermAwareComponent.class.isAssignableFrom(clazz)) continue;
            actual.add(clazz);
        }
        for (Class<?> clazz : this.getCharFilters().values()) {
            if (!MultiTermAwareComponent.class.isAssignableFrom(clazz)) continue;
            actual.add(clazz);
        }
        HashSet classesMissingMultiTermSupport = new HashSet(expected);
        classesMissingMultiTermSupport.removeAll(actual);
        AnalysisFactoryTestCase.assertTrue((String)("Classes are missing multi-term support: " + classesMissingMultiTermSupport), (boolean)classesMissingMultiTermSupport.isEmpty());
        HashSet classesThatShouldNotHaveMultiTermSupport = new HashSet(actual);
        classesThatShouldNotHaveMultiTermSupport.removeAll(expected);
        AnalysisFactoryTestCase.assertTrue((String)("Classes should not have multi-term support: " + classesThatShouldNotHaveMultiTermSupport), (boolean)classesThatShouldNotHaveMultiTermSupport.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    public void testPreBuiltMultiTermAware() {
        HashSet<String> expected = new HashSet<String>();
        HashSet<String> actual = new HashSet<String>();
        HashMap preConfiguredTokenFilters = new HashMap(AnalysisModule.setupPreConfiguredTokenFilters(Collections.singletonList(this.plugin)));
        for (Map.Entry<String, Class<?>> entry : this.getPreConfiguredTokenFilters().entrySet()) {
            void var7_13;
            String string = entry.getKey();
            Class<?> clazz = entry.getValue();
            PreConfiguredTokenFilter filter = (PreConfiguredTokenFilter)preConfiguredTokenFilters.remove(string);
            AnalysisFactoryTestCase.assertNotNull((String)("test claims pre built token filter [" + string + "] should be available but it wasn't"), (Object)filter);
            if (clazz == Void.class) continue;
            if (clazz == null) {
                Class clazz2 = TokenFilterFactory.lookupClass((String)AnalysisFactoryTestCase.toCamelCase(string));
            }
            AnalysisFactoryTestCase.assertThat((Object)var7_13, (Matcher)Matchers.typeCompatibleWith(TokenFilterFactory.class));
            if (filter.shouldUseFilterForMultitermQueries()) {
                actual.add("token filter [" + string + "]");
            }
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom((Class<?>)var7_13)) continue;
            expected.add("token filter [" + string + "]");
        }
        AnalysisFactoryTestCase.assertThat((String)"pre configured token filter not registered with test", preConfiguredTokenFilters.keySet(), (Matcher)Matchers.empty());
        HashMap preConfiguredTokenizers = new HashMap(AnalysisModule.setupPreConfiguredTokenizers(Collections.singletonList(this.plugin)));
        for (Map.Entry<String, Class<?>> entry : this.getPreConfiguredTokenizers().entrySet()) {
            String string = entry.getKey();
            Class luceneFactory = entry.getValue();
            PreConfiguredTokenizer tokenizer = (PreConfiguredTokenizer)preConfiguredTokenizers.remove(string);
            AnalysisFactoryTestCase.assertNotNull((String)("test claims pre built tokenizer [" + string + "] should be available but it wasn't"), (Object)tokenizer);
            if (luceneFactory == Void.class) continue;
            if (luceneFactory == null) {
                luceneFactory = TokenizerFactory.lookupClass((String)AnalysisFactoryTestCase.toCamelCase(string));
            }
            AnalysisFactoryTestCase.assertThat((Object)luceneFactory, (Matcher)Matchers.typeCompatibleWith(TokenizerFactory.class));
            if (tokenizer.hasMultiTermComponent()) {
                actual.add((String)tokenizer);
            }
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(luceneFactory)) continue;
            expected.add((String)tokenizer);
        }
        AnalysisFactoryTestCase.assertThat((String)"pre configured tokenizer not registered with test", preConfiguredTokenizers.keySet(), (Matcher)Matchers.empty());
        HashMap hashMap = new HashMap(AnalysisModule.setupPreConfiguredCharFilters(Collections.singletonList(this.plugin)));
        for (Map.Entry<String, Class<?>> entry : this.getPreConfiguredCharFilters().entrySet()) {
            String name = entry.getKey();
            Class luceneFactory = entry.getValue();
            PreConfiguredCharFilter filter = (PreConfiguredCharFilter)hashMap.remove(name);
            AnalysisFactoryTestCase.assertNotNull((String)("test claims pre built char filter [" + name + "] should be available but it wasn't"), (Object)filter);
            if (luceneFactory == Void.class) continue;
            if (luceneFactory == null) {
                luceneFactory = TokenFilterFactory.lookupClass((String)AnalysisFactoryTestCase.toCamelCase(name));
            }
            AnalysisFactoryTestCase.assertThat((Object)luceneFactory, (Matcher)Matchers.typeCompatibleWith(CharFilterFactory.class));
            if (filter.shouldUseFilterForMultitermQueries()) {
                actual.add((String)filter);
            }
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(luceneFactory)) continue;
            expected.add("token filter [" + name + "]");
        }
        AnalysisFactoryTestCase.assertThat((String)"pre configured char filter not registered with test", hashMap.keySet(), (Matcher)Matchers.empty());
        HashSet hashSet = new HashSet(expected);
        hashSet.removeAll(actual);
        AnalysisFactoryTestCase.assertTrue((String)("Pre-built components are missing multi-term support: " + hashSet), (boolean)hashSet.isEmpty());
        HashSet hashSet2 = new HashSet(actual);
        hashSet2.removeAll(expected);
        AnalysisFactoryTestCase.assertTrue((String)("Pre-built components should not have multi-term support: " + hashSet2), (boolean)hashSet2.isEmpty());
    }

    protected static final class MovedToAnalysisCommon {
        private MovedToAnalysisCommon() {
        }
    }
}

