/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingHelper;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.TestShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MapperTestUtils;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.EngineTestCase;
import org.elasticsearch.index.engine.InternalEngineFactory;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexSearcherWrapper;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.node.Node;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.test.DummyShardLock;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class IndexShardTestCase
extends ESTestCase {
    public static final IndexEventListener EMPTY_EVENT_LISTENER = new IndexEventListener(){};
    private static final AtomicBoolean failOnShardFailures = new AtomicBoolean(true);
    private static final Consumer<IndexShard.ShardFailure> DEFAULT_SHARD_FAILURE_HANDLER = failure -> {
        if (failOnShardFailures.get()) {
            throw new AssertionError(failure.reason, failure.cause);
        }
    };
    protected static final PeerRecoveryTargetService.RecoveryListener recoveryListener = new PeerRecoveryTargetService.RecoveryListener(){

        public void onRecoveryDone(RecoveryState state) {
        }

        public void onRecoveryFailure(RecoveryState state, RecoveryFailedException e, boolean sendShardFailure) {
            throw new AssertionError(e);
        }
    };
    protected ThreadPool threadPool;
    private long primaryTerm;
    protected static AtomicLong currentClusterStateVersion = new AtomicLong();

    public void setUp() throws Exception {
        super.setUp();
        this.threadPool = new TestThreadPool(((Object)((Object)this)).getClass().getName(), this.threadPoolSettings());
        this.primaryTerm = IndexShardTestCase.randomIntBetween(1, 100);
        failOnShardFailures.set(true);
    }

    public void tearDown() throws Exception {
        try {
            ThreadPool.terminate((ThreadPool)this.threadPool, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            super.tearDown();
        }
    }

    protected void allowShardFailures() {
        failOnShardFailures.set(false);
    }

    public Settings threadPoolSettings() {
        return Settings.EMPTY;
    }

    protected Store createStore(IndexSettings indexSettings, ShardPath shardPath) throws IOException {
        return this.createStore(shardPath.getShardId(), indexSettings, (Directory)IndexShardTestCase.newFSDirectory((Path)shardPath.resolveIndex()));
    }

    protected Store createStore(ShardId shardId, IndexSettings indexSettings, final Directory directory) throws IOException {
        DirectoryService directoryService = new DirectoryService(shardId, indexSettings){

            public Directory newDirectory() throws IOException {
                return directory;
            }
        };
        return new Store(shardId, indexSettings, directoryService, (ShardLock)new DummyShardLock(shardId));
    }

    protected IndexShard newShard(boolean primary) throws IOException {
        ShardRouting shardRouting = TestShardRouting.newShardRouting(new ShardId("index", "_na_", 0), IndexShardTestCase.randomAlphaOfLength(10), primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.StoreRecoverySource.EMPTY_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        return this.newShard(shardRouting, new IndexingOperationListener[0]);
    }

    protected IndexShard newShard(ShardRouting shardRouting, IndexingOperationListener ... listeners) throws IOException {
        assert (shardRouting.initializing()) : shardRouting;
        Settings settings = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 0).put("index.number_of_shards", 1).build();
        IndexMetaData.Builder metaData = IndexMetaData.builder((String)shardRouting.getIndexName()).settings(settings).primaryTerm(0, this.primaryTerm).putMapping("_doc", "{ \"properties\": {} }");
        return this.newShard(shardRouting, metaData.build(), listeners);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, IndexingOperationListener ... listeners) throws IOException {
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, IndexShardTestCase.randomAlphaOfLength(5), primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.StoreRecoverySource.EMPTY_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        return this.newShard(shardRouting, listeners);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, String nodeId, IndexMetaData indexMetaData, @Nullable IndexSearcherWrapper searcherWrapper) throws IOException {
        return this.newShard(shardId, primary, nodeId, indexMetaData, searcherWrapper, () -> {});
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, String nodeId, IndexMetaData indexMetaData, @Nullable IndexSearcherWrapper searcherWrapper, Runnable globalCheckpointSyncer) throws IOException {
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, nodeId, primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.StoreRecoverySource.EMPTY_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        return this.newShard(shardRouting, indexMetaData, searcherWrapper, (EngineFactory)new InternalEngineFactory(), globalCheckpointSyncer, new IndexingOperationListener[0]);
    }

    protected IndexShard newShard(ShardRouting routing, IndexMetaData indexMetaData, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(routing, indexMetaData, null, (EngineFactory)new InternalEngineFactory(), () -> {}, listeners);
    }

    protected IndexShard newShard(ShardRouting routing, IndexMetaData indexMetaData, @Nullable IndexSearcherWrapper indexSearcherWrapper, @Nullable EngineFactory engineFactory, Runnable globalCheckpointSyncer, IndexingOperationListener ... listeners) throws IOException {
        ShardId shardId = routing.shardId();
        NodeEnvironment.NodePath nodePath = new NodeEnvironment.NodePath(IndexShardTestCase.createTempDir());
        ShardPath shardPath = new ShardPath(false, nodePath.resolve(shardId), nodePath.resolve(shardId), shardId);
        return this.newShard(routing, shardPath, indexMetaData, null, indexSearcherWrapper, engineFactory, globalCheckpointSyncer, EMPTY_EVENT_LISTENER, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IndexShard newShard(ShardRouting routing, ShardPath shardPath, IndexMetaData indexMetaData, @Nullable Store store, @Nullable IndexSearcherWrapper indexSearcherWrapper, @Nullable EngineFactory engineFactory, Runnable globalCheckpointSyncer, IndexEventListener indexEventListener, IndexingOperationListener ... listeners) throws IOException {
        Settings nodeSettings = Settings.builder().put("node.name", routing.currentNodeId()).build();
        IndexSettings indexSettings = new IndexSettings(indexMetaData, nodeSettings);
        if (store == null) {
            store = this.createStore(indexSettings, shardPath);
        }
        boolean success = false;
        try {
            IndexCache indexCache = new IndexCache(indexSettings, (QueryCache)new DisabledQueryCache(indexSettings), null);
            MapperService mapperService = MapperTestUtils.newMapperService(this.xContentRegistry(), IndexShardTestCase.createTempDir(), indexSettings.getSettings(), "index");
            mapperService.merge(indexMetaData, MapperService.MergeReason.MAPPING_RECOVERY, true);
            SimilarityService similarityService = new SimilarityService(indexSettings, null, Collections.emptyMap());
            Engine.Warmer warmer = searcher -> {};
            ClusterSettings clusterSettings = new ClusterSettings(nodeSettings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
            HierarchyCircuitBreakerService breakerService = new HierarchyCircuitBreakerService(nodeSettings, clusterSettings);
            IndexShard indexShard = new IndexShard(routing, indexSettings, shardPath, store, () -> null, indexCache, mapperService, similarityService, engineFactory, indexEventListener, indexSearcherWrapper, this.threadPool, BigArrays.NON_RECYCLING_INSTANCE, warmer, Collections.emptyList(), Arrays.asList(listeners), globalCheckpointSyncer, (CircuitBreakerService)breakerService);
            indexShard.addShardFailureCallback(DEFAULT_SHARD_FAILURE_HANDLER);
            return indexShard;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.close((Closeable[])new Closeable[]{store});
            throw throwable;
        }
    }

    protected IndexShard reinitShard(IndexShard current, IndexingOperationListener ... listeners) throws IOException {
        ShardRouting shardRouting;
        return this.reinitShard(current, ShardRoutingHelper.initWithSameId(shardRouting, (RecoverySource)((shardRouting = current.routingEntry()).primary() ? RecoverySource.StoreRecoverySource.EXISTING_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE)), listeners);
    }

    protected IndexShard reinitShard(IndexShard current, ShardRouting routing, IndexingOperationListener ... listeners) throws IOException {
        this.closeShards(current);
        return this.newShard(routing, current.shardPath(), current.indexSettings().getIndexMetaData(), null, null, current.engineFactory, current.getGlobalCheckpointSyncer(), EMPTY_EVENT_LISTENER, listeners);
    }

    protected IndexShard newStartedShard() throws IOException {
        return this.newStartedShard(IndexShardTestCase.randomBoolean());
    }

    protected IndexShard newStartedShard(boolean primary) throws IOException {
        IndexShard shard = this.newShard(primary);
        if (primary) {
            this.recoverShardFromStore(shard);
        } else {
            this.recoveryEmptyReplica(shard, true);
        }
        return shard;
    }

    protected void closeShards(IndexShard ... shards) throws IOException {
        this.closeShards(Arrays.asList(shards));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeShards(Iterable<IndexShard> shards) throws IOException {
        for (IndexShard shard : shards) {
            if (shard == null) continue;
            try {
                shard.close("test", false);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{shard.store()});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{shard.store()});
        }
    }

    protected void recoverShardFromStore(IndexShard primary) throws IOException {
        primary.markAsRecovering("store", new RecoveryState(primary.routingEntry(), this.getFakeDiscoNode(primary.routingEntry().currentNodeId()), null));
        primary.recoverFromStore();
        IndexShardTestCase.updateRoutingEntry(primary, ShardRoutingHelper.moveToStarted(primary.routingEntry()));
    }

    public static void updateRoutingEntry(IndexShard shard, ShardRouting shardRouting) throws IOException {
        Set inSyncIds = shardRouting.active() ? Collections.singleton(shardRouting.allocationId().getId()) : Collections.emptySet();
        IndexShardRoutingTable newRoutingTable = new IndexShardRoutingTable.Builder(shardRouting.shardId()).addShard(shardRouting).build();
        shard.updateShardState(shardRouting, shard.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIds, newRoutingTable, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoveryEmptyReplica(IndexShard replica, boolean startReplica) throws IOException {
        IndexShard primary = null;
        try {
            primary = this.newStartedShard(true);
            this.recoverReplica(replica, primary, startReplica);
        }
        catch (Throwable throwable) {
            this.closeShards(primary);
            throw throwable;
        }
        this.closeShards(primary);
    }

    protected DiscoveryNode getFakeDiscoNode(String id) {
        return new DiscoveryNode(id, id, IndexShardTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), EnumSet.allOf(DiscoveryNode.Role.class), Version.CURRENT);
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, boolean startReplica) throws IOException {
        this.recoverReplica(replica, primary, (r, sourceNode) -> new RecoveryTarget(r, sourceNode, recoveryListener, version -> {}), true, true);
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering, boolean markAsStarted) throws IOException {
        IndexShardRoutingTable.Builder newRoutingTable = new IndexShardRoutingTable.Builder(replica.shardId());
        newRoutingTable.addShard(primary.routingEntry());
        if (!replica.routingEntry().isRelocationTarget()) {
            newRoutingTable.addShard(replica.routingEntry());
        }
        Set<String> inSyncIds = Collections.singleton(primary.routingEntry().allocationId().getId());
        IndexShardRoutingTable routingTable = newRoutingTable.build();
        this.recoverUnstartedReplica(replica, primary, targetSupplier, markAsRecovering, inSyncIds, routingTable);
        if (markAsStarted) {
            this.startReplicaAfterRecovery(replica, primary, inSyncIds, routingTable);
        }
    }

    protected final void recoverUnstartedReplica(IndexShard replica, IndexShard primary, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering, Set<String> inSyncIds, IndexShardRoutingTable routingTable) throws IOException {
        DiscoveryNode pNode = this.getFakeDiscoNode(primary.routingEntry().currentNodeId());
        DiscoveryNode rNode = this.getFakeDiscoNode(replica.routingEntry().currentNodeId());
        if (markAsRecovering) {
            replica.markAsRecovering("remote", new RecoveryState(replica.routingEntry(), pNode, rNode));
        } else {
            IndexShardTestCase.assertEquals((Object)replica.state(), (Object)IndexShardState.RECOVERING);
        }
        replica.prepareForIndexRecovery();
        RecoveryTarget recoveryTarget = targetSupplier.apply(replica, pNode);
        String targetAllocationId = recoveryTarget.indexShard().routingEntry().allocationId().getId();
        Store.MetadataSnapshot snapshot = this.getMetadataSnapshotOrEmpty(replica);
        long startingSeqNo = snapshot.size() > 0 ? PeerRecoveryTargetService.getStartingSeqNo((Logger)this.logger, (RecoveryTarget)recoveryTarget) : -2L;
        StartRecoveryRequest request = new StartRecoveryRequest(replica.shardId(), targetAllocationId, pNode, rNode, snapshot, replica.routingEntry().primary(), 0L, startingSeqNo);
        RecoverySourceHandler recovery = new RecoverySourceHandler(primary, (RecoveryTargetHandler)recoveryTarget, request, (int)ByteSizeUnit.MB.toBytes(1L), Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), pNode.getName()).build());
        primary.updateShardState(primary.routingEntry(), primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIds, routingTable, Collections.emptySet());
        recovery.recoverToTarget();
        recoveryTarget.markAsDone();
    }

    protected void startReplicaAfterRecovery(IndexShard replica, IndexShard primary, Set<String> inSyncIds, IndexShardRoutingTable routingTable) throws IOException {
        ShardRouting initializingReplicaRouting = replica.routingEntry();
        IndexShardRoutingTable newRoutingTable = initializingReplicaRouting.isRelocationTarget() ? new IndexShardRoutingTable.Builder(routingTable).removeShard(primary.routingEntry()).addShard(replica.routingEntry()).build() : new IndexShardRoutingTable.Builder(routingTable).removeShard(initializingReplicaRouting).addShard(replica.routingEntry()).build();
        HashSet<String> inSyncIdsWithReplica = new HashSet<String>(inSyncIds);
        inSyncIdsWithReplica.add(replica.routingEntry().allocationId().getId());
        primary.updateShardState(primary.routingEntry(), primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIdsWithReplica, newRoutingTable, Collections.emptySet());
        replica.updateShardState(replica.routingEntry().moveToStarted(), replica.getPendingPrimaryTerm(), null, currentClusterStateVersion.get(), inSyncIdsWithReplica, newRoutingTable, Collections.emptySet());
    }

    protected void promoteReplica(IndexShard replica, Set<String> inSyncIds, IndexShardRoutingTable routingTable) throws IOException {
        IndexShardTestCase.assertThat(inSyncIds, (Matcher)Matchers.contains((Object[])new String[]{replica.routingEntry().allocationId().getId()}));
        ShardRouting routingEntry = TestShardRouting.newShardRouting(replica.routingEntry().shardId(), replica.routingEntry().currentNodeId(), null, true, ShardRoutingState.STARTED, replica.routingEntry().allocationId());
        IndexShardRoutingTable newRoutingTable = new IndexShardRoutingTable.Builder(routingTable).removeShard(replica.routingEntry()).addShard(routingEntry).build();
        replica.updateShardState(routingEntry, replica.getPendingPrimaryTerm() + 1L, (is, listener) -> listener.onResponse((Object)new PrimaryReplicaSyncer.ResyncTask(1L, "type", "action", "desc", null, Collections.emptyMap())), currentClusterStateVersion.incrementAndGet(), inSyncIds, newRoutingTable, Collections.emptySet());
    }

    private Store.MetadataSnapshot getMetadataSnapshotOrEmpty(IndexShard replica) throws IOException {
        Store.MetadataSnapshot result;
        try {
            result = replica.snapshotStoreMetadata();
        }
        catch (IndexNotFoundException e) {
            result = Store.MetadataSnapshot.EMPTY;
        }
        catch (IOException e) {
            this.logger.warn("failed read store, treating as empty", (Throwable)e);
            result = Store.MetadataSnapshot.EMPTY;
        }
        return result;
    }

    protected Set<String> getShardDocUIDs(IndexShard shard) throws IOException {
        shard.refresh("get_uids");
        try (Engine.Searcher searcher = shard.acquireSearcher("test");){
            HashSet<String> ids = new HashSet<String>();
            for (LeafReaderContext leafContext : searcher.reader().leaves()) {
                LeafReader reader = leafContext.reader();
                Bits liveDocs = reader.getLiveDocs();
                for (int i = 0; i < reader.maxDoc(); ++i) {
                    if (liveDocs != null && !liveDocs.get(i)) continue;
                    Document uuid = reader.document(i, Collections.singleton("_id"));
                    BytesRef binaryID = uuid.getBinaryValue("_id");
                    ids.add(Uid.decodeId((byte[])Arrays.copyOfRange(binaryID.bytes, binaryID.offset, binaryID.offset + binaryID.length)));
                }
            }
            HashSet<String> hashSet = ids;
            return hashSet;
        }
    }

    protected void assertDocCount(IndexShard shard, int docDount) throws IOException {
        IndexShardTestCase.assertThat(this.getShardDocUIDs(shard), (Matcher)Matchers.hasSize((int)docDount));
    }

    protected void assertDocs(IndexShard shard, String ... ids) throws IOException {
        Set<String> shardDocUIDs = this.getShardDocUIDs(shard);
        IndexShardTestCase.assertThat(shardDocUIDs, (Matcher)Matchers.contains((Object[])ids));
        IndexShardTestCase.assertThat(shardDocUIDs, (Matcher)Matchers.hasSize((int)ids.length));
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String type, String id) throws IOException {
        return this.indexDoc(shard, type, id, "{}");
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String type, String id, String source) throws IOException {
        return this.indexDoc(shard, type, id, source, XContentType.JSON, null, null);
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String type, String id, String source, XContentType xContentType, String routing, String parentId) throws IOException {
        Engine.IndexResult result;
        SourceToParse sourceToParse = SourceToParse.source((String)shard.shardId().getIndexName(), (String)type, (String)id, (BytesReference)new BytesArray(source), (XContentType)xContentType);
        sourceToParse.routing(routing);
        sourceToParse.parent(parentId);
        if (shard.routingEntry().primary()) {
            result = shard.applyIndexOperationOnPrimary(-3L, VersionType.INTERNAL, sourceToParse, -1L, false);
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                this.updateMappings(shard, IndexMetaData.builder((IndexMetaData)shard.indexSettings().getIndexMetaData()).putMapping(type, result.getRequiredMappingUpdate().toString()).build());
                result = shard.applyIndexOperationOnPrimary(-3L, VersionType.INTERNAL, sourceToParse, -1L, false);
            }
            shard.updateLocalCheckpointForShard(shard.routingEntry().allocationId().getId(), shard.getLocalCheckpoint());
        } else {
            result = shard.applyIndexOperationOnReplica(shard.seqNoStats().getMaxSeqNo() + 1L, 0L, VersionType.EXTERNAL, -1L, false, sourceToParse);
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(shard.shardId, "Mappings are not available on the replica yet, triggered update: " + result.getRequiredMappingUpdate());
            }
        }
        return result;
    }

    protected void updateMappings(IndexShard shard, IndexMetaData indexMetadata) {
        shard.indexSettings().updateIndexMetaData(indexMetadata);
        shard.mapperService().merge(indexMetadata, MapperService.MergeReason.MAPPING_UPDATE, true);
    }

    protected Engine.DeleteResult deleteDoc(IndexShard shard, String type, String id) throws IOException {
        if (shard.routingEntry().primary()) {
            return shard.applyDeleteOperationOnPrimary(-3L, type, id, VersionType.INTERNAL);
        }
        return shard.applyDeleteOperationOnReplica(shard.seqNoStats().getMaxSeqNo() + 1L, 0L, type, id, VersionType.EXTERNAL);
    }

    protected void flushShard(IndexShard shard) {
        this.flushShard(shard, false);
    }

    protected void flushShard(IndexShard shard, boolean force) {
        shard.flush(new FlushRequest(new String[]{shard.shardId().getIndexName()}).force(force));
    }

    protected void recoverShardFromSnapshot(IndexShard shard, Snapshot snapshot, Repository repository) throws IOException {
        Version version = Version.CURRENT;
        ShardId shardId = shard.shardId();
        String index = shardId.getIndexName();
        IndexId indexId = new IndexId(shardId.getIndex().getName(), shardId.getIndex().getUUID());
        DiscoveryNode node = this.getFakeDiscoNode(shard.routingEntry().currentNodeId());
        RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(snapshot, version, index);
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, node.getId(), true, (RecoverySource)recoverySource, ShardRoutingState.INITIALIZING);
        shard.markAsRecovering("from snapshot", new RecoveryState(shardRouting, node, null));
        repository.restoreShard(shard, snapshot.getSnapshotId(), version, indexId, shard.shardId(), shard.recoveryState());
    }

    protected void snapshotShard(IndexShard shard, Snapshot snapshot, Repository repository) throws IOException {
        IndexShardSnapshotStatus snapshotStatus = IndexShardSnapshotStatus.newInitializing();
        try (Engine.IndexCommitRef indexCommitRef = shard.acquireLastIndexCommit(true);){
            Index index = shard.shardId().getIndex();
            IndexId indexId = new IndexId(index.getName(), index.getUUID());
            repository.snapshotShard(shard, snapshot.getSnapshotId(), indexId, indexCommitRef.getIndexCommit(), snapshotStatus);
        }
        IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
        IndexShardTestCase.assertEquals((Object)IndexShardSnapshotStatus.Stage.DONE, (Object)lastSnapshotStatus.getStage());
        IndexShardTestCase.assertEquals((long)shard.snapshotStoreMetadata().size(), (long)lastSnapshotStatus.getTotalFileCount());
        IndexShardTestCase.assertNull((Object)lastSnapshotStatus.getFailure());
    }

    public static Engine getEngine(IndexShard indexShard) {
        return indexShard.getEngine();
    }

    public static Translog getTranslog(IndexShard shard) {
        return EngineTestCase.getTranslog(IndexShardTestCase.getEngine(shard));
    }

    public static ReplicationTracker getReplicationTracker(IndexShard indexShard) {
        return indexShard.getReplicationTracker();
    }
}

