/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.Elements;
import org.elasticsearch.common.inject.spi.InstanceBinding;
import org.elasticsearch.common.inject.spi.LinkedKeyBinding;
import org.elasticsearch.common.inject.spi.ProviderInstanceBinding;
import org.elasticsearch.common.inject.spi.ProviderLookup;
import org.elasticsearch.common.inject.spi.UntargettedBinding;
import org.elasticsearch.test.ESTestCase;

public abstract class ModuleTestCase
extends ESTestCase {
    public void assertBinding(Module module, Class to, Class clazz) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        for (Element element : elements) {
            LinkedKeyBinding binding;
            if (element instanceof LinkedKeyBinding) {
                binding = (LinkedKeyBinding)element;
                if (!to.equals(binding.getKey().getTypeLiteral().getType())) continue;
                ModuleTestCase.assertSame((Object)clazz, (Object)binding.getLinkedKey().getTypeLiteral().getType());
                return;
            }
            if (!(element instanceof UntargettedBinding) || !to.equals((binding = (UntargettedBinding)element).getKey().getTypeLiteral().getType())) continue;
            ModuleTestCase.assertSame((Object)clazz, (Object)to);
            return;
        }
        StringBuilder s = new StringBuilder();
        for (Element element : elements) {
            s.append(element).append("\n");
        }
        ModuleTestCase.fail((String)("Did not find any binding to " + to.getName() + ". Found these bindings:\n" + s));
    }

    public void assertNotBound(Module module, Class clazz) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        for (Element element : elements) {
            LinkedKeyBinding binding;
            if (element instanceof LinkedKeyBinding) {
                binding = (LinkedKeyBinding)element;
                if (!clazz.equals(binding.getKey().getTypeLiteral().getType())) continue;
                ModuleTestCase.fail((String)("Found binding for " + clazz.getName() + " to " + binding.getKey().getTypeLiteral().getType().getTypeName()));
                continue;
            }
            if (!(element instanceof UntargettedBinding) || !clazz.equals((binding = (UntargettedBinding)element).getKey().getTypeLiteral().getType())) continue;
            ModuleTestCase.fail((String)("Found binding for " + clazz.getName()));
        }
    }

    public void assertBindingFailure(Module module, String ... msgs) {
        try {
            List elements = Elements.getElements((Module[])new Module[]{module});
            StringBuilder s = new StringBuilder();
            for (Element element : elements) {
                s.append(element).append("\n");
            }
            ModuleTestCase.fail((String)("Expected exception from configuring module. Found these bindings:\n" + s));
        }
        catch (IllegalArgumentException e) {
            for (String msg : msgs) {
                ModuleTestCase.assertTrue((String)(e.getMessage() + " didn't contain: " + msg), (boolean)e.getMessage().contains(msg));
            }
        }
    }

    public void assertMapMultiBinding(Module module, Class to, Class theClass) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        HashSet<Type> bindings = new HashSet<Type>();
        boolean providerFound = false;
        for (Element element : elements) {
            String setType;
            LinkedKeyBinding binding;
            if (element instanceof LinkedKeyBinding) {
                binding = (LinkedKeyBinding)element;
                if (!to.equals(binding.getKey().getTypeLiteral().getType())) continue;
                bindings.add(binding.getLinkedKey().getTypeLiteral().getType());
                continue;
            }
            if (!(element instanceof ProviderInstanceBinding) || !(setType = (binding = (ProviderInstanceBinding)element).getKey().getTypeLiteral().getType().toString()).equals("java.util.Map<java.lang.String, " + to.getName() + ">")) continue;
            providerFound = true;
        }
        if (!bindings.contains(theClass)) {
            ModuleTestCase.fail((String)("Expected to find " + theClass.getName() + " as binding to " + to.getName() + ", found these classes:\n" + bindings));
        }
        ModuleTestCase.assertTrue((String)("Did not find provider for map of " + to.getName()), (boolean)providerFound);
    }

    public void assertSetMultiBinding(Module module, Class to, Class ... classes) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        HashSet<Type> bindings = new HashSet<Type>();
        boolean providerFound = false;
        for (Element element : elements) {
            String setType;
            LinkedKeyBinding binding;
            if (element instanceof LinkedKeyBinding) {
                binding = (LinkedKeyBinding)element;
                if (!to.equals(binding.getKey().getTypeLiteral().getType())) continue;
                bindings.add(binding.getLinkedKey().getTypeLiteral().getType());
                continue;
            }
            if (!(element instanceof ProviderInstanceBinding) || !(setType = (binding = (ProviderInstanceBinding)element).getKey().getTypeLiteral().getType().toString()).equals("java.util.Set<" + to.getName() + ">")) continue;
            providerFound = true;
        }
        for (Class clazz : classes) {
            if (bindings.contains(clazz)) continue;
            ModuleTestCase.fail((String)("Expected to find " + clazz.getName() + " as set binding to " + to.getName() + ", found these classes:\n" + bindings));
        }
        ModuleTestCase.assertTrue((String)("Did not find provider for set of " + to.getName()), (boolean)providerFound);
    }

    public <T> void assertInstanceBinding(Module module, Class<T> to, Predicate<T> tester) {
        this.assertInstanceBindingWithAnnotation(module, to, tester, null);
    }

    public static <T> T bindAndGetInstance(Module module, Class<T> to) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        for (Element element : elements) {
            InstanceBinding binding;
            if (element instanceof InstanceBinding) {
                binding = (InstanceBinding)element;
                if (!to.equals(binding.getKey().getTypeLiteral().getType())) continue;
                return to.cast(binding.getInstance());
            }
            if (!(element instanceof ProviderInstanceBinding) || !to.equals((binding = (ProviderInstanceBinding)element).getKey().getTypeLiteral().getType())) continue;
            return to.cast(binding.getProviderInstance().get());
        }
        ModuleTestCase.fail((String)("can't get instance for class " + to));
        return null;
    }

    public <T> void assertInstanceBindingWithAnnotation(Module module, Class<T> to, Predicate<T> tester, Class<? extends Annotation> annotation) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        for (Element element : elements) {
            InstanceBinding binding;
            if (element instanceof InstanceBinding) {
                binding = (InstanceBinding)element;
                if (!to.equals(binding.getKey().getTypeLiteral().getType()) || annotation != null && !annotation.equals(binding.getKey().getAnnotationType())) continue;
                ModuleTestCase.assertTrue((boolean)tester.test(to.cast(binding.getInstance())));
                return;
            }
            if (!(element instanceof ProviderInstanceBinding) || !to.equals((binding = (ProviderInstanceBinding)element).getKey().getTypeLiteral().getType())) continue;
            ModuleTestCase.assertTrue((boolean)tester.test(to.cast(binding.getProviderInstance().get())));
            return;
        }
        StringBuilder s = new StringBuilder();
        for (Element element : elements) {
            s.append(element).append("\n");
        }
        ModuleTestCase.fail((String)("Did not find any instance binding to " + to.getName() + ". Found these bindings:\n" + s));
    }

    public <K, V> void assertMapInstanceBinding(Module module, Class<K> keyType, Class<V> valueType, Map<K, V> expected) throws Exception {
        HashMap keys = new HashMap();
        HashMap<Key, Object> values = new HashMap<Key, Object>();
        List elements = Elements.getElements((Module[])new Module[]{module});
        for (Element element : elements) {
            if (!(element instanceof InstanceBinding)) continue;
            InstanceBinding binding = (InstanceBinding)element;
            if (binding.getKey().getRawType().equals(valueType)) {
                values.put(binding.getKey(), binding.getInstance());
                continue;
            }
            if (!(binding.getInstance() instanceof Map.Entry)) continue;
            Map.Entry entry = (Map.Entry)binding.getInstance();
            Object key = entry.getKey();
            Object providerValue = entry.getValue();
            if (!key.getClass().equals(keyType) || !(providerValue instanceof ProviderLookup.ProviderImpl)) continue;
            ProviderLookup.ProviderImpl provider = (ProviderLookup.ProviderImpl)providerValue;
            keys.put(key, provider.getKey());
        }
        for (Map.Entry entry : expected.entrySet()) {
            Key valueKey = (Key)keys.get(entry.getKey());
            ModuleTestCase.assertNotNull((String)("Could not find binding for key [" + entry.getKey() + "], found these keys:\n" + keys.keySet()), (Object)valueKey);
            Object value = values.get(valueKey);
            ModuleTestCase.assertNotNull((Object)("Could not find value for instance key [" + valueKey + "], found these bindings:\n" + elements));
            ModuleTestCase.assertEquals(entry.getValue(), value);
        }
    }
}

