/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.Arrays;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

public class SearchRequestCacheDisablingInterceptor
implements RequestInterceptor {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;

    public SearchRequestCacheDisablingInterceptor(ThreadPool threadPool, XPackLicenseState licenseState) {
        this.threadContext = threadPool.getThreadContext();
        this.licenseState = licenseState;
    }

    @Override
    public SubscribableListener<Void> intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authorizationEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        boolean isDlsLicensed = SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState);
        boolean isFlsLicensed = SecurityField.FIELD_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState);
        TransportRequest transportRequest = requestInfo.getRequest();
        if (transportRequest instanceof SearchRequest) {
            IndicesAccessControl indicesAccessControl;
            SearchRequest searchRequest = (SearchRequest)transportRequest;
            if (!TransportActionProxy.isProxyAction((String)requestInfo.getAction()) && SearchRequestCacheDisablingInterceptor.hasRemoteIndices(searchRequest) && (isDlsLicensed || isFlsLicensed) && (indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions")).getFieldAndDocumentLevelSecurityUsage() != IndicesAccessControl.DlsFlsUsage.NONE) {
                searchRequest.requestCache(Boolean.valueOf(false));
            }
        }
        return SubscribableListener.nullSuccess();
    }

    static boolean hasRemoteIndices(SearchRequest request) {
        return Arrays.stream(request.indices()).anyMatch(RemoteClusterAware::isRemoteIndexName);
    }
}

