/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authz.RoleMappingMetadata;
import org.elasticsearch.xpack.security.authc.support.mapper.AbstractRoleMapperClearRealmCache;

public class ProjectStateRoleMapper
extends AbstractRoleMapperClearRealmCache
implements ClusterStateListener {
    public static final String CLUSTER_STATE_ROLE_MAPPINGS_ENABLED = "xpack.security.authc.cluster_state_role_mappings.enabled";
    private static final Logger logger = LogManager.getLogger(ProjectStateRoleMapper.class);
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;
    private final boolean enabled;

    public ProjectStateRoleMapper(Settings settings, ScriptService scriptService, ClusterService clusterService, ProjectResolver projectResolver) {
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.enabled = settings.getAsBoolean(CLUSTER_STATE_ROLE_MAPPINGS_ENABLED, Boolean.valueOf(true));
        this.projectResolver = projectResolver;
        if (this.enabled) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        listener.onResponse((Object)ExpressionRoleMapping.resolveRoles((UserRoleMapper.UserData)user, this.getMappings(), (ScriptService)this.scriptService, (Logger)logger));
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (this.enabled && this.roleMappingsChanged(event)) {
            this.clearRealmCachesOnLocalNode();
        }
    }

    private boolean roleMappingsChanged(ClusterChangedEvent event) {
        Map previousProjects = event.previousState().metadata().projects();
        for (ProjectMetadata currentProject : event.state().metadata().projects().values()) {
            RoleMappingMetadata previousMapping;
            RoleMappingMetadata currentMapping = RoleMappingMetadata.getFromProject((ProjectMetadata)currentProject);
            ProjectMetadata previousProject = (ProjectMetadata)previousProjects.get(currentProject.id());
            if (!(previousProject == null ? currentMapping != null : false == Objects.equals(previousMapping = RoleMappingMetadata.getFromProject((ProjectMetadata)previousProject), currentMapping))) continue;
            return true;
        }
        return false;
    }

    public boolean hasMapping(String name) {
        if (!this.enabled) {
            return false;
        }
        return false == this.getMappings(Set.of(name)).isEmpty();
    }

    public Set<ExpressionRoleMapping> getMappings() {
        return this.getMappings(null);
    }

    public Set<ExpressionRoleMapping> getMappings(@Nullable Set<String> names) {
        if (!this.enabled) {
            return Set.of();
        }
        ProjectMetadata project = this.projectResolver.getProjectMetadata(this.clusterService.state());
        Set mappings = RoleMappingMetadata.getFromProject((ProjectMetadata)project).getRoleMappings();
        logger.trace("Retrieved [{}] mapping(s) from cluster state", (Object)mappings.size());
        if (names == null || names.isEmpty()) {
            return mappings;
        }
        return mappings.stream().filter(roleMapping -> names.contains(roleMapping.getName())).collect(Collectors.toSet());
    }
}

