/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.slowlog;

import java.util.Map;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingSlowLog;
import org.elasticsearch.index.SearchSlowLog;
import org.elasticsearch.index.SlowLogFieldProvider;
import org.elasticsearch.xpack.security.Security;

public class SecuritySlowLogFieldProvider
implements SlowLogFieldProvider {
    private final Security plugin;
    private boolean includeUserInIndexing = false;
    private boolean includeUserInSearch = false;

    public SecuritySlowLogFieldProvider() {
        throw new IllegalStateException("Provider must be constructed using PluginsService");
    }

    public SecuritySlowLogFieldProvider(Security plugin) {
        this.plugin = plugin;
    }

    public void init(IndexSettings indexSettings) {
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(SearchSlowLog.INDEX_SEARCH_SLOWLOG_INCLUDE_USER_SETTING, newValue -> {
            this.includeUserInSearch = newValue;
        });
        this.includeUserInSearch = (Boolean)indexSettings.getValue(SearchSlowLog.INDEX_SEARCH_SLOWLOG_INCLUDE_USER_SETTING);
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_INCLUDE_USER_SETTING, newValue -> {
            this.includeUserInIndexing = newValue;
        });
        this.includeUserInIndexing = (Boolean)indexSettings.getValue(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_INCLUDE_USER_SETTING);
    }

    public Map<String, String> indexSlowLogFields() {
        if (this.includeUserInIndexing) {
            return this.plugin.getAuthContextForSlowLog();
        }
        return Map.of();
    }

    public Map<String, String> searchSlowLogFields() {
        if (this.includeUserInSearch) {
            return this.plugin.getAuthContextForSlowLog();
        }
        return Map.of();
    }
}

