/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserResponse;
import org.elasticsearch.xpack.security.rest.action.user.NativeUserBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestDeleteUserAction
extends NativeUserBaseRestHandler {
    public RestDeleteUserAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.DELETE, (String)"/_security/user/{username}").replaces(RestRequest.Method.DELETE, "/_xpack/security/user/{username}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_delete_user_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String username = request.param("username");
        String refresh = request.param("refresh");
        return channel -> ((DeleteUserRequestBuilder)new DeleteUserRequestBuilder((ElasticsearchClient)client).username(username).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<DeleteUserResponse>(channel){

            public RestResponse buildResponse(DeleteUserResponse response, XContentBuilder builder) throws Exception {
                return new RestResponse(response.found() ? RestStatus.OK : RestStatus.NOT_FOUND, builder.startObject().field("found", response.found()).endObject());
            }
        });
    }
}

