/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.saml;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public abstract class SamlBaseRestHandler
extends SecurityBaseRestHandler {
    private static final Logger logger = LogManager.getLogger(SamlBaseRestHandler.class);
    private static final String SAML_REALM_TYPE = "saml";

    public SamlBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    @Override
    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        if (Realms.isRealmTypeAvailable(this.licenseState, SAML_REALM_TYPE)) {
            return null;
        }
        logger.info("The '{}' realm is not available under the current license", (Object)SAML_REALM_TYPE);
        return LicenseUtils.newComplianceException((String)SAML_REALM_TYPE);
    }
}

