/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.privilege;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.privilege.GetBuiltinPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.GetBuiltinPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.privilege.GetBuiltinPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.privilege.GetBuiltinPrivilegesResponseTranslator;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetBuiltinPrivilegesAction
extends SecurityBaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestGetBuiltinPrivilegesAction.class);
    private final GetBuiltinPrivilegesResponseTranslator responseTranslator;

    public RestGetBuiltinPrivilegesAction(Settings settings, XPackLicenseState licenseState, GetBuiltinPrivilegesResponseTranslator responseTranslator) {
        super(settings, licenseState);
        this.responseTranslator = responseTranslator;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/privilege/_builtin"));
    }

    public String getName() {
        return "security_get_builtin_privileges_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        return channel -> client.execute((ActionType)GetBuiltinPrivilegesAction.INSTANCE, (ActionRequest)new GetBuiltinPrivilegesRequest(), (ActionListener)new RestBuilderListener<GetBuiltinPrivilegesResponse>(channel){

            public RestResponse buildResponse(GetBuiltinPrivilegesResponse response, XContentBuilder builder) throws Exception {
                GetBuiltinPrivilegesResponse translatedResponse = RestGetBuiltinPrivilegesAction.this.responseTranslator.translate(response);
                builder.startObject();
                builder.array("cluster", translatedResponse.getClusterPrivileges());
                builder.array("index", translatedResponse.getIndexPrivileges());
                String[] remoteClusterPrivileges = translatedResponse.getRemoteClusterPrivileges();
                if (remoteClusterPrivileges.length > 0) {
                    builder.array("remote_cluster", remoteClusterPrivileges);
                }
                builder.endObject();
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        boolean shouldRestrictForServerless = this.shouldRestrictForServerless(request);
        assert (!shouldRestrictForServerless || DiscoveryNode.isStateless((Settings)this.settings));
        if (!shouldRestrictForServerless) {
            return super.innerCheckFeatureAvailable(request);
        }
        Boolean nativeRolesEnabled = this.settings.getAsBoolean("xpack.security.authc.native_roles.enabled", Boolean.valueOf(true));
        if (!nativeRolesEnabled.booleanValue()) {
            logger.debug("Attempt to call [{} {}] but [{}] is [{}]", (Object)request.method(), (Object)request.rawPath(), (Object)"xpack.security.authc.native_roles.enabled", (Object)this.settings.get("xpack.security.authc.native_roles.enabled"));
            return new ElasticsearchStatusException("This API is not enabled on this Elasticsearch instance", RestStatus.GONE, new Object[0]);
        }
        return null;
    }

    private boolean shouldRestrictForServerless(RestRequest request) {
        return request.isServerlessRequest() && false == request.isOperatorRequest();
    }
}

