/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingResponse;
import org.elasticsearch.xpack.security.authc.support.mapper.ClusterStateRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class TransportDeleteRoleMappingAction
extends HandledTransportAction<DeleteRoleMappingRequest, DeleteRoleMappingResponse> {
    private final NativeRoleMappingStore roleMappingStore;
    private final ClusterStateRoleMapper clusterStateRoleMapper;

    @Inject
    public TransportDeleteRoleMappingAction(ActionFilters actionFilters, TransportService transportService, NativeRoleMappingStore roleMappingStore, ClusterStateRoleMapper clusterStateRoleMapper) {
        super("cluster:admin/xpack/security/role_mapping/delete", transportService, actionFilters, DeleteRoleMappingRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.roleMappingStore = roleMappingStore;
        this.clusterStateRoleMapper = clusterStateRoleMapper;
    }

    protected void doExecute(Task task, DeleteRoleMappingRequest request, ActionListener<DeleteRoleMappingResponse> listener) {
        this.roleMappingStore.deleteRoleMapping(request, (ActionListener<Boolean>)listener.safeMap(found -> {
            if (found.booleanValue() && this.clusterStateRoleMapper.hasMapping(request.getName())) {
                HeaderWarning.addWarning((String)("A read-only role mapping with the same name [" + request.getName() + "] has previously been defined in a configuration file. The native role mapping was deleted, but the read-only mapping will remain active and will be used to determine role assignments."), (Object[])new Object[0]);
            }
            return new DeleteRoleMappingResponse(found.booleanValue());
        }));
    }
}

