/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;

abstract class PoolingSessionFactory
extends SessionFactory
implements Releasable {
    private final boolean useConnectionPool;
    private final LDAPConnectionPool connectionPool;
    final SimpleBindRequest bindCredentials;
    final LdapSession.GroupsResolver groupResolver;

    PoolingSessionFactory(RealmConfig config, SSLService sslService, LdapSession.GroupsResolver groupResolver, Setting.AffixSetting<Boolean> poolingEnabled, @Nullable String bindDn, Supplier<String> healthCheckDNSupplier, ThreadPool threadPool) throws LDAPException {
        super(config, sslService, threadPool);
        byte[] bindPassword;
        this.groupResolver = groupResolver;
        if (config.hasSetting(PoolingSessionFactorySettings.LEGACY_BIND_PASSWORD)) {
            if (config.hasSetting(PoolingSessionFactorySettings.SECURE_BIND_PASSWORD)) {
                throw new IllegalArgumentException("You cannot specify both [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Function)PoolingSessionFactorySettings.LEGACY_BIND_PASSWORD) + "] and [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Function)PoolingSessionFactorySettings.SECURE_BIND_PASSWORD) + "]");
            }
            bindPassword = CharArrays.toUtf8Bytes((char[])((SecureString)config.getSetting(PoolingSessionFactorySettings.LEGACY_BIND_PASSWORD)).getChars());
        } else {
            bindPassword = config.hasSetting(PoolingSessionFactorySettings.SECURE_BIND_PASSWORD) ? CharArrays.toUtf8Bytes((char[])((SecureString)config.getSetting(PoolingSessionFactorySettings.SECURE_BIND_PASSWORD)).getChars()) : null;
        }
        this.bindCredentials = bindDn == null ? new SimpleBindRequest() : new SimpleBindRequest(bindDn, bindPassword);
        this.useConnectionPool = (Boolean)config.getSetting(poolingEnabled);
        this.connectionPool = this.useConnectionPool ? PoolingSessionFactory.createConnectionPool(config, this.serverSet, this.timeout, this.logger, (BindRequest)this.bindCredentials, healthCheckDNSupplier) : null;
    }

    @Override
    public final void session(String user, SecureString password, ActionListener<LdapSession> listener) {
        if (this.useConnectionPool) {
            this.getSessionWithPool(this.connectionPool, user, password, listener);
        } else {
            this.getSessionWithoutPool(user, password, listener);
        }
    }

    @Override
    public final void unauthenticatedSession(String user, ActionListener<LdapSession> listener) {
        if (this.useConnectionPool) {
            this.getUnauthenticatedSessionWithPool(this.connectionPool, user, listener);
        } else {
            this.getUnauthenticatedSessionWithoutPool(user, listener);
        }
    }

    abstract void getSessionWithPool(LDAPConnectionPool var1, String var2, SecureString var3, ActionListener<LdapSession> var4);

    abstract void getSessionWithoutPool(String var1, SecureString var2, ActionListener<LdapSession> var3);

    abstract void getUnauthenticatedSessionWithPool(LDAPConnectionPool var1, String var2, ActionListener<LdapSession> var3);

    abstract void getUnauthenticatedSessionWithoutPool(String var1, ActionListener<LdapSession> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LDAPConnectionPool createConnectionPool(RealmConfig config, ServerSet serverSet, TimeValue timeout, Logger logger, BindRequest bindRequest, Supplier<String> healthCheckDnSupplier) throws LDAPException {
        int initialSize = (Integer)config.getSetting(PoolingSessionFactorySettings.POOL_INITIAL_SIZE);
        int size = (Integer)config.getSetting(PoolingSessionFactorySettings.POOL_SIZE);
        LDAPConnectionPool pool = null;
        boolean success = false;
        try {
            pool = (LDAPConnectionPool)LdapUtils.privilegedConnect(() -> new LDAPConnectionPool(serverSet, bindRequest, initialSize, size));
            pool.setConnectionPoolName("ldap-pool-" + config.identifier());
            pool.setRetryFailedOperationsDueToInvalidConnections(true);
            if (((Boolean)config.getSetting(PoolingSessionFactorySettings.HEALTH_CHECK_ENABLED)).booleanValue()) {
                String entryDn = ((Optional)config.getSetting(PoolingSessionFactorySettings.HEALTH_CHECK_DN)).orElseGet(healthCheckDnSupplier);
                long healthCheckInterval = ((TimeValue)config.getSetting(PoolingSessionFactorySettings.HEALTH_CHECK_INTERVAL)).millis();
                if (entryDn != null) {
                    GetEntryLDAPConnectionPoolHealthCheck healthCheck = new GetEntryLDAPConnectionPoolHealthCheck(entryDn, timeout.millis(), false, false, false, true, false);
                    pool.setHealthCheck((LDAPConnectionPoolHealthCheck)healthCheck);
                    pool.setHealthCheckIntervalMillis(healthCheckInterval);
                } else {
                    logger.warn((Message)new ParameterizedMessage("[{}] and [{}} have not been specified or are not valid distinguished names,so connection health checking is disabled", (Object)RealmSettings.getFullSettingKey((RealmConfig)config, (Function)PoolingSessionFactorySettings.BIND_DN), (Object)RealmSettings.getFullSettingKey((RealmConfig)config, (Function)PoolingSessionFactorySettings.HEALTH_CHECK_DN)));
                }
            }
            success = true;
            LDAPConnectionPool lDAPConnectionPool = pool;
            return lDAPConnectionPool;
        }
        finally {
            if (!success && pool != null) {
                pool.close();
            }
        }
    }

    @Override
    public final void close() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
        }
    }

    LDAPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }
}

