/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.saml.SamlSpMetadataRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlSpMetadataResponse;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlSpMetadataBuilder;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorMarshaller;
import org.w3c.dom.Element;

public class TransportSamlSpMetadataAction
extends HandledTransportAction<SamlSpMetadataRequest, SamlSpMetadataResponse> {
    private final Realms realms;

    @Inject
    public TransportSamlSpMetadataAction(TransportService transportService, ActionFilters actionFilters, Realms realms) {
        super("cluster:monitor/xpack/security/saml/metadata", transportService, actionFilters, SamlSpMetadataRequest::new);
        this.realms = realms;
    }

    protected void doExecute(Task task, SamlSpMetadataRequest request, ActionListener<SamlSpMetadataResponse> listener) {
        List<SamlRealm> realms = SamlRealm.findSamlRealms(this.realms, request.getRealmName(), null);
        if (realms.isEmpty()) {
            listener.onFailure((Exception)SamlUtils.samlException("Cannot find any matching realm for [{}]", request.getRealmName()));
        } else if (realms.size() > 1) {
            listener.onFailure((Exception)SamlUtils.samlException("Found multiple matching realms [{}] for [{}]", realms, request.getRealmName()));
        } else {
            this.prepareMetadata(realms.get(0), listener);
        }
    }

    private void prepareMetadata(SamlRealm realm, ActionListener<SamlSpMetadataResponse> listener) {
        try {
            EntityDescriptorMarshaller marshaller = new EntityDescriptorMarshaller();
            SpConfiguration spConfig = realm.getServiceProvider();
            SamlSpMetadataBuilder builder = new SamlSpMetadataBuilder(Locale.getDefault(), spConfig.getEntityId()).assertionConsumerServiceUrl(spConfig.getAscUrl()).singleLogoutServiceUrl(spConfig.getLogoutUrl()).encryptionCredentials(spConfig.getEncryptionCredentials()).signingCredential(spConfig.getSigningConfiguration().getCredential()).authnRequestsSigned(spConfig.getSigningConfiguration().shouldSign("AuthnRequest"));
            EntityDescriptor descriptor = builder.build();
            Element element = marshaller.marshall((XMLObject)descriptor);
            StringWriter writer = new StringWriter();
            Transformer serializer = SamlUtils.getHardenedXMLTransformer();
            serializer.transform(new DOMSource(element), new StreamResult(writer));
            listener.onResponse((Object)new SamlSpMetadataResponse(writer.toString()));
        }
        catch (Exception e) {
            this.logger.error((Message)new ParameterizedMessage("Error during SAML SP metadata generation for realm [{}]", (Object)realm.name()), (Throwable)e);
            listener.onFailure(e);
        }
    }
}

