/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.ssl.SSLService;

public final class ProfileConfigurations {
    private ProfileConfigurations() {
    }

    public static Map<String, SslConfiguration> get(Settings settings, SSLService sslService, SslConfiguration defaultConfiguration) {
        Set profileNames = settings.getGroups("transport.profiles.", true).keySet();
        Map profileConfiguration = Maps.newMapWithExpectedSize((int)(profileNames.size() + 1));
        for (String profileName : profileNames) {
            if (profileName.equals("default")) {
                if (settings.getByPrefix("transport.profiles.default.xpack.security.ssl.").isEmpty()) continue;
                throw new IllegalArgumentException("SSL settings should not be configured for the default profile. Use the [xpack.security.transport.ssl] settings instead.");
            }
            SslConfiguration configuration = sslService.getSSLConfiguration("transport.profiles." + profileName + "." + SecurityField.setting((String)"ssl"));
            profileConfiguration.put(profileName, configuration);
        }
        assert (!profileConfiguration.containsKey("default"));
        profileConfiguration.put("default", defaultConfiguration);
        return profileConfiguration;
    }
}

