/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.List;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestClearRolesCacheAction
extends SecurityBaseRestHandler {
    public RestClearRolesCacheAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public java.util.List<RestHandler.Route> routes() {
        return List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/role/{name}/_clear_cache").replaces(RestRequest.Method.POST, "/_xpack/security/role/{name}/_clear_cache", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_clear_roles_cache_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] roles = request.paramAsStringArrayOrEmptyIfAll("name");
        ClearRolesCacheRequest req = new ClearRolesCacheRequest().names(roles);
        return channel -> new SecurityClient((ElasticsearchClient)client).clearRolesCache(req, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }
}

