/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.MemoizedSupplier;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

abstract class FieldAndDocumentLevelSecurityRequestInterceptor
implements RequestInterceptor {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final Logger logger;

    FieldAndDocumentLevelSecurityRequestInterceptor(ThreadContext threadContext, XPackLicenseState licenseState) {
        this.threadContext = threadContext;
        this.licenseState = licenseState;
        this.logger = LogManager.getLogger(this.getClass());
    }

    @Override
    public void intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authorizationEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<Void> listener) {
        if (requestInfo.getRequest() instanceof IndicesRequest && !TransportActionProxy.isProxyAction((String)requestInfo.getAction())) {
            IndicesRequest indicesRequest = (IndicesRequest)requestInfo.getRequest();
            boolean shouldIntercept = this.licenseState.isSecurityEnabled();
            if (this.supports(indicesRequest) && shouldIntercept) {
                MemoizedSupplier licenseChecker = new MemoizedSupplier(() -> this.licenseState.checkFeature(XPackLicenseState.Feature.SECURITY_DLS_FLS));
                IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
                HashMap<String, IndicesAccessControl.IndexAccessControl> accessControlByIndex = new HashMap<String, IndicesAccessControl.IndexAccessControl>();
                for (String index : this.requestIndices(indicesRequest)) {
                    IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
                    if (indexAccessControl != null) {
                        boolean flsEnabled = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                        boolean dlsEnabled = indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions();
                        if (!flsEnabled && !dlsEnabled || !((Boolean)licenseChecker.get()).booleanValue()) continue;
                        this.logger.trace("intercepted request for index [{}] with field level access controls [{}] document level access controls [{}]. disabling conflicting features", (Object)index, (Object)flsEnabled, (Object)dlsEnabled);
                        accessControlByIndex.put(index, indexAccessControl);
                        continue;
                    }
                    this.logger.trace("intercepted request for index [{}] without field or document level access controls", (Object)index);
                }
                if (!accessControlByIndex.isEmpty()) {
                    this.disableFeatures(indicesRequest, accessControlByIndex, listener);
                    return;
                }
            }
        }
        listener.onResponse(null);
    }

    abstract void disableFeatures(IndicesRequest var1, Map<String, IndicesAccessControl.IndexAccessControl> var2, ActionListener<Void> var3);

    String[] requestIndices(IndicesRequest indicesRequest) {
        return indicesRequest.indices();
    }

    abstract boolean supports(IndicesRequest var1);
}

