/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsResponse;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.service.ElasticServiceAccounts;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.support.HttpTlsRuntimeCheck;

public class ServiceAccountService {
    private static final Logger logger = LogManager.getLogger(ServiceAccountService.class);
    private static final int MIN_TOKEN_SECRET_LENGTH = 10;
    private final ServiceAccountTokenStore serviceAccountTokenStore;
    private final HttpTlsRuntimeCheck httpTlsRuntimeCheck;

    public ServiceAccountService(ServiceAccountTokenStore serviceAccountTokenStore, HttpTlsRuntimeCheck httpTlsRuntimeCheck) {
        this.serviceAccountTokenStore = serviceAccountTokenStore;
        this.httpTlsRuntimeCheck = httpTlsRuntimeCheck;
    }

    public static boolean isServiceAccountPrincipal(String principal) {
        return ElasticServiceAccounts.ACCOUNTS.containsKey(principal);
    }

    public static Collection<String> getServiceAccountPrincipals() {
        return ElasticServiceAccounts.ACCOUNTS.keySet();
    }

    public static Map<String, ServiceAccount> getServiceAccounts() {
        return org.elasticsearch.core.Map.copyOf(ElasticServiceAccounts.ACCOUNTS);
    }

    public static ServiceAccountToken tryParseToken(SecureString bearerString) {
        try {
            if (bearerString == null) {
                return null;
            }
            return ServiceAccountToken.fromBearerString(bearerString);
        }
        catch (Exception e) {
            logger.trace("Cannot parse possible service account token", (Throwable)e);
            return null;
        }
    }

    public void findTokensFor(ServiceAccount.ServiceAccountId accountId, String nodeName, ActionListener<GetServiceAccountCredentialsResponse> listener) {
        this.serviceAccountTokenStore.findTokensFor(accountId, (ActionListener<Collection<TokenInfo>>)ActionListener.wrap(tokenInfos -> listener.onResponse((Object)new GetServiceAccountCredentialsResponse(accountId.asPrincipal(), nodeName, tokenInfos)), arg_0 -> listener.onFailure(arg_0)));
    }

    public void authenticateToken(ServiceAccountToken serviceAccountToken, String nodeName, ActionListener<Authentication> listener) {
        logger.trace("attempt to authenticate service account token [{}]", (Object)serviceAccountToken.getQualifiedName());
        this.httpTlsRuntimeCheck.checkTlsThenExecute(arg_0 -> listener.onFailure(arg_0), "service account authentication", () -> {
            if (!"elastic".equals(serviceAccountToken.getAccountId().namespace())) {
                logger.debug("only [{}] service accounts are supported, but received [{}]", (Object)"elastic", (Object)serviceAccountToken.getAccountId().asPrincipal());
                listener.onFailure((Exception)((Object)this.createAuthenticationException(serviceAccountToken)));
                return;
            }
            ServiceAccount account = ElasticServiceAccounts.ACCOUNTS.get(serviceAccountToken.getAccountId().asPrincipal());
            if (account == null) {
                logger.debug("the [{}] service account does not exist", (Object)serviceAccountToken.getAccountId().asPrincipal());
                listener.onFailure((Exception)((Object)this.createAuthenticationException(serviceAccountToken)));
                return;
            }
            if (serviceAccountToken.getSecret().length() < 10) {
                logger.debug("failing authentication for service account token [{}], the provided credential has length [{}] but a token's secret value must be at least [{}] characters", (Object)serviceAccountToken.getQualifiedName(), (Object)serviceAccountToken.getSecret().length(), (Object)10);
                listener.onFailure((Exception)((Object)this.createAuthenticationException(serviceAccountToken)));
                return;
            }
            this.serviceAccountTokenStore.authenticate(serviceAccountToken, (ActionListener<ServiceAccountTokenStore.StoreAuthenticationResult>)ActionListener.wrap(storeAuthenticationResult -> {
                if (storeAuthenticationResult.isSuccess()) {
                    listener.onResponse((Object)this.createAuthentication(account, serviceAccountToken, storeAuthenticationResult.getTokenSource(), nodeName));
                } else {
                    ElasticsearchSecurityException e = this.createAuthenticationException(serviceAccountToken);
                    logger.debug(e.getMessage());
                    listener.onFailure((Exception)((Object)e));
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        });
    }

    public void getRoleDescriptor(Authentication authentication, ActionListener<RoleDescriptor> listener) {
        assert (authentication.isServiceAccount()) : "authentication is not for service account: " + authentication;
        this.httpTlsRuntimeCheck.checkTlsThenExecute(arg_0 -> listener.onFailure(arg_0), "service account role descriptor resolving", () -> {
            String principal = authentication.getUser().principal();
            ServiceAccount account = ElasticServiceAccounts.ACCOUNTS.get(principal);
            if (account == null) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("cannot load role for service account [" + principal + "] - no such service account", new Object[0])));
                return;
            }
            listener.onResponse((Object)account.roleDescriptor());
        });
    }

    private Authentication createAuthentication(ServiceAccount account, ServiceAccountToken token, TokenInfo.TokenSource tokenSource, String nodeName) {
        User user = account.asUser();
        Authentication.RealmRef authenticatedBy = new Authentication.RealmRef("_service_account", "_service_account", nodeName);
        return new Authentication(user, authenticatedBy, null, Version.CURRENT, Authentication.AuthenticationType.TOKEN, org.elasticsearch.core.Map.of((Object)"_token_name", (Object)token.getTokenName(), (Object)"_token_source", (Object)tokenSource.name().toLowerCase(Locale.ROOT)));
    }

    private ElasticsearchSecurityException createAuthenticationException(ServiceAccountToken serviceAccountToken) {
        return new ElasticsearchSecurityException("failed to authenticate service account [{}] with token name [{}]", RestStatus.UNAUTHORIZED, new Object[]{serviceAccountToken.getAccountId().asPrincipal(), serviceAccountToken.getTokenName()});
    }
}

