/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.saml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.saml.SamlCompleteLogoutAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlCompleteLogoutRequest;
import org.elasticsearch.xpack.security.rest.action.saml.SamlBaseRestHandler;

public class RestSamlCompleteLogoutAction
extends SamlBaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestSamlCompleteLogoutAction.class);
    static final ObjectParser<SamlCompleteLogoutRequest, Void> PARSER = new ObjectParser("saml_complete_logout", SamlCompleteLogoutRequest::new);

    public RestSamlCompleteLogoutAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public String getName() {
        return "security_saml_complete_logout_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_security/saml/complete_logout"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            SamlCompleteLogoutRequest samlCompleteLogoutRequest = (SamlCompleteLogoutRequest)PARSER.parse(parser, null);
            logger.trace("SAML LogoutResponse: [{}...] [{}...] [{}]", (Object)Strings.cleanTruncate((String)samlCompleteLogoutRequest.getQueryString(), (int)128), (Object)Strings.cleanTruncate((String)samlCompleteLogoutRequest.getContent(), (int)128), (Object)samlCompleteLogoutRequest.getValidRequestIds());
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)SamlCompleteLogoutAction.INSTANCE, (ActionRequest)samlCompleteLogoutRequest, (ActionListener)new RestBuilderListener<ActionResponse.Empty>(channel){

                public RestResponse buildResponse(ActionResponse.Empty response, XContentBuilder builder) throws Exception {
                    builder.startObject().endObject();
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareStringOrNull(SamlCompleteLogoutRequest::setQueryString, new ParseField("queryString", new String[0]));
        PARSER.declareStringOrNull(SamlCompleteLogoutRequest::setContent, new ParseField("content", new String[0]));
        PARSER.declareStringArray(SamlCompleteLogoutRequest::setValidRequestIds, new ParseField("ids", new String[0]));
        PARSER.declareString(SamlCompleteLogoutRequest::setRealm, new ParseField("realm", new String[0]));
    }
}

