/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class ApiKeyGenerator {
    private final ApiKeyService apiKeyService;
    private final CompositeRolesStore rolesStore;
    private final NamedXContentRegistry xContentRegistry;

    public ApiKeyGenerator(ApiKeyService apiKeyService, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        this.apiKeyService = apiKeyService;
        this.rolesStore = rolesStore;
        this.xContentRegistry = xContentRegistry;
    }

    public void generateApiKey(Authentication authentication, CreateApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        if (authentication == null) {
            listener.onFailure((Exception)new ElasticsearchSecurityException("no authentication available to generate API key", new Object[0]));
            return;
        }
        this.apiKeyService.ensureEnabled();
        if (Authentication.AuthenticationType.API_KEY == authentication.getAuthenticationType() && this.grantsAnyPrivileges(request)) {
            listener.onFailure((Exception)new IllegalArgumentException("creating derived api keys requires an explicit role descriptor that is empty (has no privileges)"));
            return;
        }
        this.rolesStore.getRoleDescriptors(new HashSet<String>(Arrays.asList(authentication.getUser().roles())), (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(roleDescriptors -> {
            for (RoleDescriptor rd : roleDescriptors) {
                try {
                    DLSRoleQueryValidator.validateQueryField((RoleDescriptor.IndicesPrivileges[])rd.getIndicesPrivileges(), (NamedXContentRegistry)this.xContentRegistry);
                }
                catch (IllegalArgumentException | ElasticsearchException e) {
                    listener.onFailure((Exception)e);
                    return;
                }
            }
            this.apiKeyService.createApiKey(authentication, request, (Set<RoleDescriptor>)roleDescriptors, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private boolean grantsAnyPrivileges(CreateApiKeyRequest request) {
        return request.getRoleDescriptors() == null || request.getRoleDescriptors().isEmpty() || false == request.getRoleDescriptors().stream().allMatch(RoleDescriptor::isEmpty);
    }
}

