/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.security.authz.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;

public class SearchRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor {
    public SearchRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState) {
        super(threadPool.getThreadContext(), licenseState);
    }

    @Override
    public void disableFeatures(IndicesRequest indicesRequest, boolean fieldLevelSecurityEnabled, boolean documentLevelSecurityEnabled, ActionListener<Void> listener) {
        SearchSourceBuilder source;
        assert (indicesRequest instanceof SearchRequest || indicesRequest instanceof ShardSearchTransportRequest) : "request must be either SearchRequest or ShardSearchTransportRequest";
        if (indicesRequest instanceof SearchRequest) {
            SearchRequest request = (SearchRequest)indicesRequest;
            request.requestCache(Boolean.valueOf(false));
            source = request.source();
        } else {
            ShardSearchTransportRequest request = (ShardSearchTransportRequest)indicesRequest;
            request.requestCache(Boolean.valueOf(false));
            source = request.source();
        }
        if (documentLevelSecurityEnabled) {
            if (source != null && source.suggest() != null) {
                listener.onFailure((Exception)new ElasticsearchSecurityException("Suggest isn't supported if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0]));
            } else if (source != null && source.profile()) {
                listener.onFailure((Exception)new ElasticsearchSecurityException("A search request cannot be profiled if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0]));
            } else {
                listener.onResponse(null);
            }
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public boolean supports(IndicesRequest request) {
        return request instanceof SearchRequest || request instanceof ShardSearchTransportRequest;
    }
}

