/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public final class ParentIdFieldMapper
extends FieldMapper {
    static final String CONTENT_TYPE = "parent";

    protected ParentIdFieldMapper(String name, boolean eagerGlobalOrdinals) {
        super(name, (MappedFieldType)new ParentIdFieldType(name, eagerGlobalOrdinals), Lucene.KEYWORD_ANALYZER, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    protected void parseCreateField(ParseContext context) {
        if (!context.externalValueSet()) {
            throw new IllegalStateException("external value not set");
        }
        String refId = (String)context.externalValue();
        BytesRef binaryValue = new BytesRef((CharSequence)refId);
        Field field = new Field(this.fieldType().name(), binaryValue, (IndexableFieldType)Defaults.FIELD_TYPE);
        context.doc().add((IndexableField)field);
        context.doc().add((IndexableField)new SortedDocValuesField(this.fieldType().name(), binaryValue));
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return null;
    }

    public static final class ParentIdFieldType
    extends StringFieldType {
        public ParentIdFieldType(String name, boolean eagerGlobalOrdinals) {
            super(name, true, false, true, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.setEagerGlobalOrdinals(eagerGlobalOrdinals);
        }

        public String typeName() {
            return ParentIdFieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES);
        }

        public ValueFetcher valueFetcher(QueryShardContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.typeName() + "].");
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    static class Defaults {
        static final FieldType FIELD_TYPE = new FieldType();

        Defaults() {
        }

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

