/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;

public final class ParentJoinFieldMapper
extends FieldMapper {
    public static final String NAME = "join";
    public static final String CONTENT_TYPE = "join";
    private List<ParentIdFieldMapper> parentIdFields;

    static String getParentIdFieldName(String joinFieldName, String parentName) {
        return joinFieldName + "#" + parentName;
    }

    static void checkPreConditions(Version indexCreatedVersion, ContentPath path, String name) {
        if (indexCreatedVersion.before(Version.V_6_0_0_alpha2)) {
            throw new IllegalStateException("unable to create join field [" + name + "] for index created before " + Version.V_6_0_0_alpha2);
        }
        if (path.pathAsText(name).contains(".")) {
            throw new IllegalArgumentException("join field [" + path.pathAsText(name) + "] cannot be added inside an object or in a multi-field");
        }
    }

    static void checkParentFields(String name, List<ParentIdFieldMapper> mappers) {
        HashSet<String> children = new HashSet<String>();
        ArrayList<String> conflicts = new ArrayList<String>();
        for (ParentIdFieldMapper mapper : mappers) {
            for (String child : mapper.getChildren()) {
                if (children.add(child)) continue;
                conflicts.add("[" + child + "] cannot have multiple parents");
            }
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("invalid definition for join field [" + name + "]:\n" + ((Object)conflicts).toString());
        }
    }

    static void checkDuplicateJoinFields(ParseContext.Document doc) {
        if (doc.getFields().stream().anyMatch(m -> m.fieldType() instanceof JoinFieldType)) {
            throw new IllegalStateException("cannot have two join fields in the same document");
        }
    }

    protected ParentJoinFieldMapper(String simpleName, MappedFieldType fieldType, Settings indexSettings, List<ParentIdFieldMapper> parentIdFields) {
        super(simpleName, fieldType, Defaults.FIELD_TYPE, indexSettings, FieldMapper.MultiFields.empty(), null);
        this.parentIdFields = parentIdFields;
    }

    protected String contentType() {
        return "join";
    }

    protected ParentJoinFieldMapper clone() {
        return (ParentJoinFieldMapper)super.clone();
    }

    public JoinFieldType fieldType() {
        return (JoinFieldType)super.fieldType();
    }

    public Iterator<Mapper> iterator() {
        return this.parentIdFields.stream().map(field -> field).iterator();
    }

    public boolean hasParent(String name) {
        return this.parentIdFields.stream().anyMatch(mapper -> name.equals(mapper.getParentName()));
    }

    public boolean hasChild(String name) {
        return this.parentIdFields.stream().anyMatch(mapper -> mapper.getChildren().contains(name));
    }

    public ParentIdFieldMapper getParentIdFieldMapper(String name, boolean isParent) {
        for (ParentIdFieldMapper mapper : this.parentIdFields) {
            if (isParent && name.equals(mapper.getParentName())) {
                return mapper;
            }
            if (isParent || !mapper.getChildren().contains(name)) continue;
            return mapper;
        }
        return null;
    }

    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        ParentJoinFieldMapper joinMergeWith = (ParentJoinFieldMapper)mergeWith;
        ArrayList<String> conflicts = new ArrayList<String>();
        for (ParentIdFieldMapper mapper : this.parentIdFields) {
            if (joinMergeWith.getParentIdFieldMapper(mapper.getParentName(), true) != null) continue;
            conflicts.add("cannot remove parent [" + mapper.getParentName() + "] in join field [" + this.name() + "]");
        }
        ArrayList<ParentIdFieldMapper> newParentIdFields = new ArrayList<ParentIdFieldMapper>();
        for (ParentIdFieldMapper mergeWithMapper : joinMergeWith.parentIdFields) {
            ParentIdFieldMapper self = this.getParentIdFieldMapper(mergeWithMapper.getParentName(), true);
            if (self == null) {
                if (this.getParentIdFieldMapper(mergeWithMapper.getParentName(), false) != null) {
                    conflicts.add("cannot create parent [" + mergeWithMapper.getParentName() + "] from an existing child");
                }
                for (String child : mergeWithMapper.getChildren()) {
                    if (this.getParentIdFieldMapper(child, true) == null) continue;
                    conflicts.add("cannot create child [" + child + "] from an existing parent");
                }
                newParentIdFields.add(mergeWithMapper);
                continue;
            }
            for (String child : self.getChildren()) {
                if (mergeWithMapper.getChildren().contains(child)) continue;
                conflicts.add("cannot remove child [" + child + "] in join field [" + this.name() + "]");
            }
            ParentIdFieldMapper merged = (ParentIdFieldMapper)self.merge((Mapper)mergeWithMapper, false);
            newParentIdFields.add(merged);
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalStateException("invalid update for join field [" + this.name() + "]:\n" + ((Object)conflicts).toString());
        }
        this.parentIdFields = Collections.unmodifiableList(newParentIdFields);
    }

    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        ParentJoinFieldMapper fieldMapper = (ParentJoinFieldMapper)super.updateFieldType(fullNameToFieldType);
        ArrayList<ParentIdFieldMapper> newMappers = new ArrayList<ParentIdFieldMapper>();
        for (ParentIdFieldMapper mapper : fieldMapper.parentIdFields) {
            newMappers.add((ParentIdFieldMapper)mapper.updateFieldType(fullNameToFieldType));
        }
        fieldMapper.parentIdFields = Collections.unmodifiableList(newMappers);
        return fieldMapper;
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("parsing is implemented in parse(), this method should NEVER be called");
    }

    public Mapper parse(ParseContext context) throws IOException {
        ParseContext externalContext;
        ParentJoinFieldMapper.checkDuplicateJoinFields(context.doc());
        context.path().add(this.simpleName());
        XContentParser.Token token = context.parser().currentToken();
        String name = null;
        String parent = null;
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = context.parser().nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = context.parser().currentName();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_STRING) continue;
                if ("name".equals(currentFieldName)) {
                    name = context.parser().text();
                    continue;
                }
                if ("parent".equals(currentFieldName)) {
                    parent = context.parser().text();
                    continue;
                }
                throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.name() + "]");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            name = context.parser().text();
            parent = null;
        } else {
            throw new IllegalStateException("[" + name + "] expected START_OBJECT or VALUE_STRING but was: " + token);
        }
        ParentIdFieldMapper parentIdField = this.getParentIdFieldMapper(name, true);
        ParentIdFieldMapper childParentIdField = this.getParentIdFieldMapper(name, false);
        if (parentIdField == null && childParentIdField == null) {
            throw new IllegalArgumentException("unknown join name [" + name + "] for field [" + this.name() + "]");
        }
        if (childParentIdField != null) {
            if (parent == null) {
                throw new IllegalArgumentException("[parent] is missing for join field [" + this.name() + "]");
            }
            if (context.sourceToParse().routing() == null) {
                throw new IllegalArgumentException("[routing] is missing for join field [" + this.name() + "]");
            }
            assert (childParentIdField.getChildren().contains(name));
            externalContext = context.createExternalValueContext((Object)parent);
            childParentIdField.parse(externalContext);
        }
        if (parentIdField != null) {
            assert (parentIdField.getParentName().equals(name));
            externalContext = context.createExternalValueContext((Object)context.sourceToParse().id());
            parentIdField.parse(externalContext);
        }
        BytesRef binaryValue = new BytesRef((CharSequence)name);
        Field field = new Field(this.fieldType().name(), binaryValue, (IndexableFieldType)this.fieldType());
        context.doc().add((IndexableField)field);
        context.doc().add((IndexableField)new SortedDocValuesField(this.fieldType().name(), binaryValue));
        context.path().remove();
        return null;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        for (ParentIdFieldMapper field : this.parentIdFields) {
            if (field.getChildren().size() == 1) {
                builder.field(field.getParentName(), field.getChildren().iterator().next());
                continue;
            }
            builder.field(field.getParentName(), field.getChildren());
        }
    }

    public static final class JoinFieldType
    extends StringFieldType {
        public JoinFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected JoinFieldType(JoinFieldType ref) {
            super((MappedFieldType)ref);
        }

        public JoinFieldType clone() {
            return new JoinFieldType(this);
        }

        public String typeName() {
            return "join";
        }

        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder();
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            IndexSettings indexSettings = parserContext.mapperService().getIndexSettings();
            if (indexSettings.getIndexMetaData().isRoutingPartitionedIndex()) {
                throw new IllegalStateException("cannot set join field [" + name + "] for the partitioned index [" + indexSettings.getIndex().getName() + "]");
            }
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Set<Object> children;
                Map.Entry<String, Object> entry = iterator.next();
                if ("type".equals(entry.getKey())) continue;
                String parent = entry.getKey();
                if (entry.getValue() instanceof List) {
                    children = new HashSet();
                    for (Object childObj : (List)entry.getValue()) {
                        if (childObj instanceof String) {
                            children.add(childObj.toString());
                            continue;
                        }
                        throw new MapperParsingException("[" + parent + "] expected an array of strings but was:" + childObj.getClass().getSimpleName());
                    }
                    children = Collections.unmodifiableSet(children);
                } else if (entry.getValue() instanceof String) {
                    children = Collections.singleton(entry.getValue().toString());
                } else {
                    throw new MapperParsingException("[" + parent + "] expected string but was:" + entry.getValue().getClass().getSimpleName());
                }
                builder.addParent(parent, children);
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, ParentJoinFieldMapper> {
        final List<ParentIdFieldMapper.Builder> parentIdFieldBuilders = new ArrayList<ParentIdFieldMapper.Builder>();

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public JoinFieldType fieldType() {
            return (JoinFieldType)super.fieldType();
        }

        public Builder addParent(String parent, Set<String> children) {
            String parentIdFieldName = ParentJoinFieldMapper.getParentIdFieldName(this.name, parent);
            this.parentIdFieldBuilders.add(new ParentIdFieldMapper.Builder(parentIdFieldName, parent, children));
            return this;
        }

        public ParentJoinFieldMapper build(Mapper.BuilderContext context) {
            ParentJoinFieldMapper.checkPreConditions(context.indexCreatedVersion(), context.path(), this.name);
            this.fieldType.setName(this.name);
            ArrayList<ParentIdFieldMapper> parentIdFields = new ArrayList<ParentIdFieldMapper>();
            this.parentIdFieldBuilders.stream().map(e -> e.build(context)).forEach(parentIdFields::add);
            ParentJoinFieldMapper.checkParentFields(this.name(), parentIdFields);
            return new ParentJoinFieldMapper(this.name, this.fieldType, context.indexSettings(), Collections.unmodifiableList(parentIdFields));
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new JoinFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

