/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;

public final class ParentIdFieldMapper
extends FieldMapper {
    static final String CONTENT_TYPE = "parent";
    private final String parentName;
    private Set<String> children;

    protected ParentIdFieldMapper(String simpleName, String parentName, Set<String> children, MappedFieldType fieldType, Settings indexSettings) {
        super(simpleName, fieldType, Defaults.FIELD_TYPE, indexSettings, FieldMapper.MultiFields.empty(), null);
        this.parentName = parentName;
        this.children = children;
    }

    protected ParentIdFieldMapper clone() {
        return (ParentIdFieldMapper)super.clone();
    }

    public String getParentName() {
        return this.parentName;
    }

    public Collection<String> getChildren() {
        return this.children;
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (!context.externalValueSet()) {
            throw new IllegalStateException("external value not set");
        }
        String refId = (String)context.externalValue();
        BytesRef binaryValue = new BytesRef((CharSequence)refId);
        Field field = new Field(this.fieldType().name(), binaryValue, (IndexableFieldType)this.fieldType());
        fields.add((IndexableField)field);
        fields.add((IndexableField)new SortedDocValuesField(this.fieldType().name(), binaryValue));
    }

    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        ParentIdFieldMapper parentMergeWith = (ParentIdFieldMapper)mergeWith;
        this.children = parentMergeWith.children;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class ParentIdFieldType
    extends StringFieldType {
        public ParentIdFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected ParentIdFieldType(ParentIdFieldType ref) {
            super((MappedFieldType)ref);
        }

        public ParentIdFieldType clone() {
            return new ParentIdFieldType(this);
        }

        public String typeName() {
            return ParentIdFieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder();
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    static class Builder
    extends FieldMapper.Builder<Builder, ParentIdFieldMapper> {
        private final String parent;
        private final Set<String> children;

        Builder(String name, String parent, Set<String> children) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
            this.parent = parent;
            this.children = children;
        }

        public Set<String> getChildren() {
            return this.children;
        }

        public ParentIdFieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setName(this.name);
            return new ParentIdFieldMapper(this.name, this.parent, this.children, this.fieldType, context.indexSettings());
        }
    }

    static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new ParentIdFieldType();

        Defaults() {
        }

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

