/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.elasticsearch.join.mapper.ParentJoinFieldMapper;

public class MetaJoinFieldMapper
extends FieldMapper {
    static final String NAME = "_parent_join";
    static final String CONTENT_TYPE = "parent_join";

    MetaJoinFieldMapper(String name, MappedFieldType fieldType, Settings indexSettings) {
        super(name, fieldType, ParentIdFieldMapper.Defaults.FIELD_TYPE, indexSettings, FieldMapper.MultiFields.empty(), null);
    }

    void setFieldMapper(ParentJoinFieldMapper mapper) {
        this.fieldType().mapper = mapper;
    }

    public MetaJoinFieldType fieldType() {
        return (MetaJoinFieldType)super.fieldType();
    }

    protected MetaJoinFieldMapper clone() {
        return (MetaJoinFieldMapper)super.clone();
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new IllegalStateException("Should never be called");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class MetaJoinFieldType
    extends StringFieldType {
        private ParentJoinFieldMapper mapper;

        MetaJoinFieldType() {
        }

        protected MetaJoinFieldType(MetaJoinFieldType ref) {
            super((MappedFieldType)ref);
        }

        public MetaJoinFieldType clone() {
            return new MetaJoinFieldType(this);
        }

        public String typeName() {
            return MetaJoinFieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder();
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        public ParentJoinFieldMapper getMapper() {
            return this.mapper;
        }
    }

    static class Builder
    extends FieldMapper.Builder<Builder, MetaJoinFieldMapper> {
        Builder() {
            super(MetaJoinFieldMapper.NAME, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public MetaJoinFieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setName(MetaJoinFieldMapper.NAME);
            return new MetaJoinFieldMapper(this.name, this.fieldType, context.indexSettings());
        }
    }

    static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new MetaJoinFieldType();

        Defaults() {
        }

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setHasDocValues(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

