/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.ScaledFloatFieldMapper;
import org.elasticsearch.index.mapper.TokenCountFieldMapper;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;

public class MapperExtrasPlugin
extends Plugin
implements MapperPlugin {
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, Object> mappers = new LinkedHashMap<String, Object>();
        mappers.put("scaled_float", new ScaledFloatFieldMapper.TypeParser());
        mappers.put("token_count", new TokenCountFieldMapper.TypeParser());
        for (RangeFieldMapper.RangeType type : RangeFieldMapper.RangeType.values()) {
            mappers.put(type.typeName(), new RangeFieldMapper.TypeParser(type));
        }
        return Collections.unmodifiableMap(mappers);
    }
}

