/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.text.Normalizer2;
import java.io.Reader;
import org.apache.lucene.analysis.icu.ICUNormalizer2CharFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractCharFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class IcuNormalizerCharFilterFactory
extends AbstractCharFilterFactory {
    private final String name;
    private final Normalizer2 normalizer;

    @Inject
    public IcuNormalizerCharFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name);
        this.name = settings.get("name", "nfkc_cf");
        String mode = settings.get("mode");
        if (!"compose".equals(mode) && !"decompose".equals(mode)) {
            mode = "compose";
        }
        this.normalizer = Normalizer2.getInstance(null, (String)this.name, (Normalizer2.Mode)("compose".equals(mode) ? Normalizer2.Mode.COMPOSE : Normalizer2.Mode.DECOMPOSE));
    }

    public Reader create(Reader reader) {
        return new ICUNormalizer2CharFilter(reader, this.normalizer);
    }
}

