/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.Transliterator;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.icu.ICUFoldingFilter;
import org.apache.lucene.analysis.icu.ICUNormalizer2CharFilter;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.apache.lucene.analysis.icu.ICUTransformFilter;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizer;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.ICUCollationKeyFilter;
import org.elasticsearch.index.analysis.PreBuiltCharFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenizerFactoryFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

public class IcuIndicesAnalysis
extends AbstractComponent {
    @Inject
    public IcuIndicesAnalysis(Settings settings, IndicesAnalysisService indicesAnalysisService) {
        super(settings);
        indicesAnalysisService.tokenizerFactories().put("icu_tokenizer", new PreBuiltTokenizerFactoryFactory(new TokenizerFactory(){

            public String name() {
                return "icu_tokenizer";
            }

            public Tokenizer create() {
                return new ICUTokenizer();
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("icu_normalizer", new PreBuiltTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "icu_normalizer";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new ICUNormalizer2Filter(tokenStream, Normalizer2.getInstance(null, (String)"nfkc_cf", (Normalizer2.Mode)Normalizer2.Mode.COMPOSE));
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("icu_folding", new PreBuiltTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "icu_folding";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new ICUFoldingFilter(tokenStream);
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("icu_collation", new PreBuiltTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "icu_collation";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new ICUCollationKeyFilter(tokenStream, Collator.getInstance());
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("icu_transform", new PreBuiltTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "icu_transform";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new ICUTransformFilter(tokenStream, Transliterator.getInstance((String)"Null", (int)0));
            }
        }));
        indicesAnalysisService.charFilterFactories().put("icu_normalizer", new PreBuiltCharFilterFactoryFactory(new CharFilterFactory(){

            public String name() {
                return "icu_normalizer";
            }

            public Reader create(Reader reader) {
                return new ICUNormalizer2CharFilter(reader);
            }
        }));
    }
}

