/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec.internal.vectorization;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.MemorySegmentAccessInput;
import org.elasticsearch.simdvec.ES91Int4VectorsScorer;
import org.elasticsearch.simdvec.ES91OSQVectorsScorer;
import org.elasticsearch.simdvec.ES92Int7VectorsScorer;
import org.elasticsearch.simdvec.internal.MemorySegmentES92Int7VectorsScorer;
import org.elasticsearch.simdvec.internal.vectorization.ESVectorUtilSupport;
import org.elasticsearch.simdvec.internal.vectorization.ESVectorizationProvider;
import org.elasticsearch.simdvec.internal.vectorization.MemorySegmentES91Int4VectorsScorer;
import org.elasticsearch.simdvec.internal.vectorization.MemorySegmentES91OSQVectorsScorer;
import org.elasticsearch.simdvec.internal.vectorization.OnHeapES91OSQVectorsScorer;
import org.elasticsearch.simdvec.internal.vectorization.PanamaESVectorUtilSupport;

final class PanamaESVectorizationProvider
extends ESVectorizationProvider {
    private final ESVectorUtilSupport vectorUtilSupport = new PanamaESVectorUtilSupport();

    PanamaESVectorizationProvider() {
    }

    @Override
    public ESVectorUtilSupport getVectorUtilSupport() {
        return this.vectorUtilSupport;
    }

    @Override
    public ES91OSQVectorsScorer newES91OSQVectorsScorer(IndexInput input, int dimension) throws IOException {
        MemorySegmentAccessInput msai;
        MemorySegment ms;
        if (PanamaESVectorUtilSupport.HAS_FAST_INTEGER_VECTORS && input instanceof MemorySegmentAccessInput && (ms = (msai = (MemorySegmentAccessInput)input).segmentSliceOrNull(0L, input.length())) != null) {
            return new MemorySegmentES91OSQVectorsScorer(input, dimension, ms);
        }
        return new OnHeapES91OSQVectorsScorer(input, dimension);
    }

    @Override
    public ES91Int4VectorsScorer newES91Int4VectorsScorer(IndexInput input, int dimension) throws IOException {
        MemorySegmentAccessInput msai;
        MemorySegment ms;
        if (PanamaESVectorUtilSupport.HAS_FAST_INTEGER_VECTORS && input instanceof MemorySegmentAccessInput && (ms = (msai = (MemorySegmentAccessInput)input).segmentSliceOrNull(0L, input.length())) != null) {
            return new MemorySegmentES91Int4VectorsScorer(input, dimension, ms);
        }
        return new ES91Int4VectorsScorer(input, dimension);
    }

    @Override
    public ES92Int7VectorsScorer newES92Int7VectorsScorer(IndexInput input, int dimension) throws IOException {
        MemorySegmentAccessInput msai;
        MemorySegment ms;
        if (input instanceof MemorySegmentAccessInput && (ms = (msai = (MemorySegmentAccessInput)input).segmentSliceOrNull(0L, input.length())) != null) {
            return new MemorySegmentES92Int7VectorsScorer(input, dimension, ms);
        }
        return new ES92Int7VectorsScorer(input, dimension);
    }
}

