/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;

public abstract class Terminal {
    private static final PrintWriter ERROR_WRITER = Terminal.newErrorWriter();
    public static final Terminal DEFAULT = ConsoleTerminal.isSupported() ? new ConsoleTerminal() : new SystemTerminal();
    private final Reader reader;
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private Verbosity currentVerbosity = Verbosity.NORMAL;

    @SuppressForbidden(reason="Writer for System.err")
    private static PrintWriter newErrorWriter() {
        return new PrintWriter(System.err, true);
    }

    protected Terminal(Reader reader, PrintWriter outWriter, PrintWriter errWriter) {
        this.reader = reader;
        this.outWriter = outWriter;
        this.errWriter = errWriter;
    }

    public void setVerbosity(Verbosity verbosity) {
        this.currentVerbosity = verbosity;
    }

    public Verbosity getVerbosity() {
        return this.currentVerbosity;
    }

    private char[] read(String prompt) {
        this.errWriter.print(prompt);
        this.errWriter.flush();
        char[] line = Terminal.readLineToCharArray(this.reader);
        if (line == null) {
            throw new IllegalStateException("unable to read from standard input; is standard input open and a tty attached?");
        }
        return line;
    }

    public String readText(String prompt) {
        return new String(this.read(prompt));
    }

    public char[] readSecret(String prompt) {
        return this.read(prompt);
    }

    public final Reader getReader() {
        return this.reader;
    }

    public final PrintWriter getWriter() {
        return this.outWriter;
    }

    public final PrintWriter getErrorWriter() {
        return this.errWriter;
    }

    @Nullable
    public InputStream getInputStream() {
        return null;
    }

    @Nullable
    public OutputStream getOutputStream() {
        return null;
    }

    public final void println(CharSequence msg) {
        this.println(Verbosity.NORMAL, msg);
    }

    public final void println(Verbosity verbosity, CharSequence msg) {
        this.print(verbosity, this.outWriter, msg, true);
    }

    public final void print(Verbosity verbosity, String msg) {
        this.print(verbosity, this.outWriter, msg, false);
    }

    protected void print(Verbosity verbosity, PrintWriter writer, CharSequence msg, boolean newline) {
        if (this.isPrintable(verbosity)) {
            if (newline) {
                writer.println(msg);
            } else {
                writer.print(msg);
            }
            writer.flush();
        }
    }

    public final void errorPrint(Verbosity verbosity, String msg) {
        this.print(verbosity, this.errWriter, msg, false);
    }

    public final void errorPrintln(String msg) {
        this.errorPrintln(Verbosity.NORMAL, msg);
    }

    public final void errorPrintln(Verbosity verbosity, String msg) {
        this.print(verbosity, this.errWriter, msg, true);
    }

    public final boolean isPrintable(Verbosity verbosity) {
        return this.currentVerbosity.ordinal() >= verbosity.ordinal();
    }

    public final boolean promptYesNo(String prompt, boolean defaultYes) {
        boolean answerYes;
        String answerPrompt;
        String string = answerPrompt = defaultYes ? " [Y/n]" : " [y/N]";
        while (true) {
            String answer;
            if ((answer = this.readText(prompt + answerPrompt)) == null || answer.isEmpty()) {
                return defaultYes;
            }
            answerYes = (answer = answer.toLowerCase(Locale.ROOT)).equals("y");
            if (answerYes || answer.equals("n")) break;
            this.errorPrintln("Did not understand answer '" + answer + "'");
        }
        return answerYes;
    }

    public static char[] readLineToCharArray(Reader reader) {
        char[] buf = new char[128];
        try {
            char nextChar;
            int next;
            int len = 0;
            while ((next = reader.read()) != -1 && (nextChar = (char)next) != '\n') {
                if (len >= buf.length) {
                    char[] newbuf = new char[buf.length * 2];
                    System.arraycopy(buf, 0, newbuf, 0, buf.length);
                    Arrays.fill(buf, '\u0000');
                    buf = newbuf;
                }
                buf[len++] = nextChar;
            }
            if (len == 0 && next == -1) {
                return null;
            }
            if (len > 0 && len < buf.length && buf[len - 1] == '\r') {
                --len;
            }
            char[] shortResult = Arrays.copyOf(buf, len);
            Arrays.fill(buf, '\u0000');
            return shortResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void flush() {
        this.outWriter.flush();
        this.errWriter.flush();
    }

    public boolean isHeadless() {
        return false;
    }

    public static enum Verbosity {
        SILENT,
        NORMAL,
        VERBOSE;

    }

    private static class ConsoleTerminal
    extends Terminal {
        private static final Console CONSOLE = System.console();

        ConsoleTerminal() {
            super(CONSOLE.reader(), CONSOLE.writer(), ERROR_WRITER);
        }

        static boolean isSupported() {
            return CONSOLE != null;
        }

        @Override
        public String readText(String prompt) {
            return CONSOLE.readLine("%s", prompt);
        }

        @Override
        public char[] readSecret(String prompt) {
            return CONSOLE.readPassword("%s", prompt);
        }
    }

    @SuppressForbidden(reason="Access streams for construction")
    static class SystemTerminal
    extends Terminal {
        SystemTerminal() {
            super(new InputStreamReader(System.in, Charset.defaultCharset()), new PrintWriter(System.out, true), ERROR_WRITER);
        }

        @Override
        public InputStream getInputStream() {
            return System.in;
        }

        @Override
        public OutputStream getOutputStream() {
            return System.out;
        }
    }
}

