/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.cli.Command;

public interface CliToolProvider {
    public String name();

    public Command create();

    public static CliToolProvider load(Map<String, String> sysprops, String toolname, String libs) {
        ClassLoader cliLoader;
        Path homeDir = Paths.get(sysprops.get("es.path.home"), new String[0]).toAbsolutePath();
        if (libs.isBlank()) {
            cliLoader = ClassLoader.getSystemClassLoader();
        } else {
            List<Path> libsToLoad = Stream.of(libs.split(",")).map(homeDir::resolve).toList();
            cliLoader = CliToolProvider.loadJars(libsToLoad);
        }
        ServiceLoader<CliToolProvider> toolFinder = ServiceLoader.load(CliToolProvider.class, cliLoader);
        List<CliToolProvider> tools = StreamSupport.stream(toolFinder.spliterator(), false).filter(p -> p.name().equals(toolname)).toList();
        if (tools.size() > 1) {
            String names = tools.stream().map(t -> t.getClass().getName()).collect(Collectors.joining(", "));
            throw new AssertionError((Object)("Multiple ToolProviders found with name [" + toolname + "]: " + names));
        }
        if (tools.size() == 0) {
            List<String> names = StreamSupport.stream(toolFinder.spliterator(), false).map(CliToolProvider::name).toList();
            throw new AssertionError((Object)("CliToolProvider [" + toolname + "] not found, available names are " + names));
        }
        return tools.get(0);
    }

    private static ClassLoader loadJars(List<Path> dirs) {
        ArrayList urls = new ArrayList();
        for (Path dir : dirs) {
            try {
                Stream<Path> jarFiles = Files.list(dir);
                try {
                    jarFiles.filter(p -> p.getFileName().toString().endsWith(".jar")).map(p -> {
                        try {
                            return p.toUri().toURL();
                        }
                        catch (MalformedURLException e) {
                            throw new AssertionError((Object)e);
                        }
                    }).forEach(urls::add);
                }
                finally {
                    if (jarFiles == null) continue;
                    jarFiles.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return URLClassLoader.newInstance((URL[])urls.toArray(URL[]::new));
    }
}

