/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.mult;

import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.sparse.csc.misc.ImplCommonOps_DSCC;

public class ImplSparseSparseMult_DSCC {
    public static void mult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, int[] w, double[] x) {
        x = ImplCommonOps_DSCC.checkDeclare(A.numRows, x);
        w = ImplCommonOps_DSCC.checkDeclare(A.numRows, w, true);
        C.indicesSorted = false;
        C.nz_length = 0;
        int idx0 = B.col_idx[0];
        for (int bj = 1; bj <= B.numCols; ++bj) {
            int colB = bj - 1;
            int idx1 = B.col_idx[bj];
            C.col_idx[bj] = C.nz_length;
            if (idx0 == idx1) continue;
            for (int bi = idx0; bi < idx1; ++bi) {
                int rowB = B.nz_rows[bi];
                double valB = B.nz_values[bi];
                ImplSparseSparseMult_DSCC.multAddColA(A, rowB, valB, C, colB, x, w);
            }
            int idxC0 = C.col_idx[colB];
            int idxC1 = C.col_idx[colB + 1];
            for (int i = idxC0; i < idxC1; ++i) {
                C.nz_values[i] = x[C.nz_rows[i]];
            }
            idx0 = idx1;
        }
    }

    public static void multAddColA(DMatrixSparseCSC A, int colA, double alpha, DMatrixSparseCSC C, int colC, double[] x, int[] w) {
        int mark = colC + 1;
        int idxA0 = A.col_idx[colA];
        int idxA1 = A.col_idx[colA + 1];
        for (int j = idxA0; j < idxA1; ++j) {
            int row = A.nz_rows[j];
            if (w[row] < mark) {
                if (C.nz_length >= C.nz_rows.length) {
                    C.growMaxLength(C.nz_length * 2 + 1, true);
                }
                w[row] = mark;
                C.nz_rows[C.nz_length] = row;
                C.col_idx[mark] = ++C.nz_length;
                x[row] = A.nz_values[j] * alpha;
                continue;
            }
            int n = row;
            x[n] = x[n] + A.nz_values[j] * alpha;
        }
    }

    public static void mult(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj C) {
        C.zero();
        for (int k = 0; k < A.numCols; ++k) {
            int idx0 = A.col_idx[k];
            int idx1 = A.col_idx[k + 1];
            for (int indexA = idx0; indexA < idx1; ++indexA) {
                int i = A.nz_rows[indexA];
                double valueA = A.nz_values[indexA];
                int indexB = k * B.numCols;
                int indexC = i * C.numCols;
                int end = indexB + B.numCols;
                while (indexB < end) {
                    int n = indexC++;
                    C.data[n] = C.data[n] + valueA * B.data[indexB++];
                }
            }
        }
    }
}

