/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.misc;

import java.util.Arrays;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.sparse.csc.mult.ImplSparseSparseMult_DSCC;

public class ImplCommonOps_DSCC {
    public static void transpose(DMatrixSparseCSC A, DMatrixSparseCSC C, int[] work) {
        int j;
        work = ImplCommonOps_DSCC.checkDeclare(A.numRows, work, true);
        C.nz_length = A.nz_length;
        int idx0 = A.col_idx[0];
        for (j = 1; j <= A.numCols; ++j) {
            int idx1 = A.col_idx[j];
            for (int i = idx0; i < idx1; ++i) {
                int n = A.nz_rows[i];
                work[n] = work[n] + 1;
            }
            idx0 = idx1;
        }
        C.colsum(work);
        idx0 = A.col_idx[0];
        for (j = 1; j <= A.numCols; ++j) {
            int col = j - 1;
            int idx1 = A.col_idx[j];
            for (int i = idx0; i < idx1; ++i) {
                int row;
                int n = row = A.nz_rows[i];
                work[n] = work[n] + 1;
                C.nz_rows[index] = col;
                C.nz_values[index] = A.nz_values[i];
            }
            idx0 = idx1;
        }
    }

    public static void add(double alpha, DMatrixSparseCSC A, double beta, DMatrixSparseCSC B, DMatrixSparseCSC C, int[] w, double[] x) {
        x = ImplCommonOps_DSCC.checkDeclare(A.numRows, x);
        w = ImplCommonOps_DSCC.checkDeclare(A.numRows, w, true);
        C.indicesSorted = false;
        C.nz_length = 0;
        for (int col = 0; col < A.numCols; ++col) {
            C.col_idx[col] = C.nz_length;
            ImplSparseSparseMult_DSCC.multAddColA(A, col, alpha, C, col, x, w);
            ImplSparseSparseMult_DSCC.multAddColA(B, col, beta, C, col, x, w);
            int idxC0 = C.col_idx[col];
            int idxC1 = C.col_idx[col + 1];
            for (int i = idxC0; i < idxC1; ++i) {
                C.nz_values[i] = x[C.nz_rows[i]];
            }
        }
    }

    public static int[] checkDeclare(int N, int[] w, boolean fillZeros) {
        if (w == null) {
            w = new int[N];
        } else {
            if (w.length < N) {
                throw new IllegalArgumentException("w needs to at least be as long as A.numRows");
            }
            if (fillZeros) {
                Arrays.fill(w, 0, N, 0);
            }
        }
        return w;
    }

    public static int[] checkDeclare(int N, int[] w, int fillToM) {
        if (w == null) {
            w = new int[N];
        } else {
            if (w.length < N) {
                throw new IllegalArgumentException("w needs to at least be as long as A.numRows");
            }
            if (fillToM > 0) {
                Arrays.fill(w, 0, fillToM, 0);
            }
        }
        return w;
    }

    public static double[] checkDeclare(int N, double[] x) {
        if (x == null) {
            x = new double[N];
        } else if (x.length < N) {
            throw new IllegalArgumentException("x needs to at least be as long as A.numRows");
        }
        return x;
    }
}

